package com.zhuge.push.msg;

import org.json.JSONArray;

import com.zhuge.push.broadcastrecievers.UserReciever;
import com.zhuge.sys.services.ManifestUtils;
import com.zhuge.sys.services.SysUtils;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;

public class ZGPush {	
	
	private static class SingletonHolder {
        static final ZGPush instance = new ZGPush();
    }
	
	public static ZGPush getInstance(){
		return SingletonHolder.instance;
	}
	
	public void initialize(Context context){
		try {
			Intent serviceIntent = SysUtils.createExplicitFromImplicitIntent(context, new Intent("com.zhuge.push.PushService"), SysUtils.getRunningServicePkg(context), ZhugePushConfig.CLS);
			serviceIntent.putExtra("cmd", ZhugePushConfig.PING);
			context.startService(serviceIntent);
			SharedPreferences sharedPreferences = context.getSharedPreferences(ZhugePushConfig.TAG, Context.MODE_PRIVATE);
			String cid = sharedPreferences.getString(ZhugePushConfig.CID, null);
			if (cid == null) {
				queryCid(context);
			}
		} catch (Exception e) {
			//e.printStackTrace();
		}
		
	}
	
	public void destroy(Context context){
		try {
			Intent serviceIntent = SysUtils.createExplicitFromImplicitIntent(context, new Intent("com.zhuge.push.PushService"), SysUtils.getRunningServicePkg(context), ZhugePushConfig.CLS);
			context.stopService(serviceIntent);
		} catch (Exception e) {
		}
		
	}
	
	public void ping(Context context){
		try {
			Intent serviceIntent = SysUtils.createExplicitFromImplicitIntent(context, new Intent("com.zhuge.push.PushService"), SysUtils.getRunningServicePkg(context), ZhugePushConfig.CLS);
			serviceIntent.putExtra("cmd", ZhugePushConfig.PING);
			context.startService(serviceIntent);
		} catch (Exception e) {
		}
		
	}
	
	public void queryCid(Context context){
		try {
			Intent serviceIntent = SysUtils.createExplicitFromImplicitIntent(context, new Intent("com.zhuge.push.PushService"), SysUtils.getRunningServicePkg(context), ZhugePushConfig.CLS);
			serviceIntent.putExtra("cmd", ZhugePushConfig.GET_CID);
			Bundle bundle = new Bundle();
			bundle.putString("appKey", ManifestUtils.getPushKey(context));
			bundle.putString("pkg", context.getPackageName());
			serviceIntent.putExtra("data", bundle);
			context.startService(serviceIntent);
		} catch (Exception e) {
		}
		
	}
	
	public JSONArray dealCustom(Activity activity){
		Intent intent = activity.getIntent();
		if (intent != null) {
			try {
				String params = intent.getStringExtra("custom");
				if (params == null) {
					return null;
				}
				JSONArray jsonArray = new JSONArray(params);
				return jsonArray;
			} catch (Exception e) {
				//e.printStackTrace();
			}
		}
		return null;
	}
	
	public void msgStatistics(Activity activity){
		Intent intent = activity.getIntent();
		if (intent != null) {
			try {
				String appid = intent.getStringExtra("appid");
				String mid = intent.getStringExtra("mid");
				if (appid != null && mid != null) {
					UserReciever.markMsg(activity.getApplicationContext(), appid, mid);
				}
			} catch (Exception e) {
				//e.printStackTrace();
			}
		}
	}
	
}
