package com.zhuge.push.msg;


import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;

import org.json.JSONObject;

public class MessageHandler {
	public final static short HEAD_LEN = 0x0008;  //头大小
	public final static short LOGIN = 0x1000;  //登录
	public final static short HEARTBEAT = 0x1002;  //心跳
	public final static short GET_CID = 0x1006;  //获取client id
	public final static short CLEAR_UNREAD = 0x1008;  //清楚未读
	public final static short MARK_READ = 0x1010;  //标记已读
	public final static short SET_BLOCK = 0x1012;  //设置屏蔽消息
	public final static short GET_BLOCK = 0x1014;  //获取屏蔽消息
	public final static short SET_AVAILABLE = 0x1016;  //设置接收时间
	public final static short GET_AVAILABLE = 0x1018;  //获取接收时间
	public final static short GET_MSG = 0x2000;  //接收消息
	public final static short COMPRESS = 0;  //压缩
	public final static short ENCRYPT = 1;  //加密
	public final static float VERION = 1;  //版本
	public static long sequence = 0;  //包序列号	
	public final static String PUBLICPEM = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCpcqqjjJTnld70B1AJvMc/HOn4LwxNbgbv1c2rWQ6W0AdXy201tLelmhblZ3ex205ILvye6YDOQK07hhdyKAeCzHtlzf46IuhMlkZjIZlSR62a1WMH7WAldzDFmHglifBg2OX/60UwPQVQb7yBCo+CJKltwXEui+aIO0Q7n05ABQIDAQAB";
	public static String privateKey = generateString("abcdefghijklmnopqrstuvwxyz1234567890", 16);	
	
	/**
	 * 构造包
	 * @param type 构造包类型
	 * @param body 包体内容
	 * @return 包
	 */
	public static byte[] constructPackage(short type, byte[] body){
		int totalLength = body.length + 8;
		byte[] header = getBytesFromShort(2, HEAD_LEN);
		byte[] cmd = getBytesFromShort(2, type);
		byte[] total = getBytesFromInt(4, totalLength);
		ByteBuffer byteBuffer = ByteBuffer.allocate(totalLength);
		byteBuffer.order(ByteOrder.BIG_ENDIAN);
		byteBuffer.put(header);
		byteBuffer.put(cmd);
		byteBuffer.put(total);
		byteBuffer.put(body);
		return byteBuffer.array();
	}
	
	
	/**
	 * 从short转成byte[]
	 * @param len byte的大小
	 * @param value short值
	 * @return byte数组
	 */
	public static byte[] getBytesFromShort(int len, short value){
		ByteBuffer byteBuffer = ByteBuffer.allocate(len);
		byteBuffer.putShort(value);
		return byteBuffer.array();
	}
	
	
	/**
	 * 从int转成byte[]
	 * @param len byte大小
	 * @param value 转换值
	 * @return byte数组
	 */
	public static byte[] getBytesFromInt(int len, int value){
		ByteBuffer byteBuffer = ByteBuffer.allocate(len);
		byteBuffer.putInt(value);
		return byteBuffer.array();
	}

	/**
	 * 登录请求
	 * @param did 设备id
	 * @return 登录包
	 */
	public static byte[] getLoginRequest(String did, long seq){
		try {
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("did", did);
			jsonObject.put("dtype", 1);
			jsonObject.put("compress", COMPRESS);
			jsonObject.put("encrypt", ENCRYPT);
			if (ENCRYPT == 1) {
				EncryptUtils encryptUtils = new EncryptUtils("RSA/ECB/PKCS1Padding");
				jsonObject.put("pwd", encryptUtils.rsaEncrypt(encryptUtils.getRsaPublicKey(PUBLICPEM), privateKey));
			}
			
			jsonObject.put("ver", VERION);
			jsonObject.put("seq", seq);
			byte[] logBytes = jsonObject.toString().getBytes();
			return constructPackage(LOGIN, logBytes);
		} catch (Exception e) {
		}
		return null;
		
	}
	
	/**
	 * 获取clientid请求
	 * @param appKey appKey
	 * @return 登录包
	 */
	public static byte[] getClientIdRequest(String appKey, long seq){
		try {
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("appid", appKey);
			jsonObject.put("dtype", 1);
			jsonObject.put("ver", VERION);
			jsonObject.put("seq", seq);
			byte[] logBytes = jsonObject.toString().getBytes();
			return constructPackage(GET_CID, logBytes);
		} catch (Exception e) {
		}
		return null;
		
	}
	
	/**
	 * 标记消息已读
	 * @param appKey 应用appkey
	 * @param mid 消息id
	 * @return 登录包
	 */
	public static byte[] getMarkReadRequest(String appKey, String mid, long seq){
		try {
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("appid", appKey);
			jsonObject.put("id", mid);
			jsonObject.put("ver", VERION);
			jsonObject.put("seq", seq);
			byte[] logBytes = jsonObject.toString().getBytes();
			return constructPackage(MARK_READ, logBytes);
		} catch (Exception e) {
		}
		return null;
		
	}
	
	
	/**
	 * 确认消息下发请求
	 * @param msgid 设备id
	 * @param appid 应用id
	 * @return 登录包
	 */
	public static byte[] confirmMsg(String msgid, int ack_type, String router, String appid){
		try {
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("id", msgid);
			jsonObject.put("appid", appid);
			jsonObject.put("ack_type", ack_type);
			jsonObject.put("router", router);
			byte[] confirmBytes = jsonObject.toString().getBytes();
			return constructPackage((short)(GET_MSG+1), confirmBytes);
		} catch (Exception e) {
		}
		return null;
		
	}
	
	/**
	 * 获取clientid请求
	 * @param seq 请求序列
	 * @return 登录包
	 */
	public static byte[] sendHeartbeat(long seq){
		try {
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("ver", VERION);
			jsonObject.put("seq", seq);
			byte[] logBytes = jsonObject.toString().getBytes();
			return constructPackage(HEARTBEAT, logBytes);
		} catch (Exception e) {
		}
		return null;
		
	}
	
	public static String generateString(String characters, int length)
	{
	    char[] text = new char[length];
	    for (int i = 0; i < length; i++)
	    {
	        text[i] = characters.charAt(new Random().nextInt(characters.length()));
	    }
	    return new String(text);
	}
}
