package com.zhuge.push.msg;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import android.util.Base64;



class EncryptUtils {
	
	private Cipher cipher;
	
	public EncryptUtils(String encryptType){
		try {
			this.cipher = Cipher.getInstance(encryptType);
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (NoSuchPaddingException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * rsa获取公钥
	 * @param pem base64encode 密钥
	 * @return
	 */
	public RSAPublicKey getRsaPublicKey(String pem){
		try {
			byte[] keyBytes = Base64.decode(pem, Base64.DEFAULT);
			X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
			KeyFactory keyFactory = KeyFactory.getInstance("RSA");
			PublicKey key = keyFactory.generatePublic(spec);
			return (RSAPublicKey)key;
		} catch (Exception e) {
			// TODO: handle exception
		}
		return null;
    }
	
	/**
	 * rsa公钥加密
	 * @param publicKey 公钥
	 * @param pwd 待加密字符串
	 * @return
	 */
	public String rsaEncrypt(RSAPublicKey publicKey, String pwd){
		try {
			cipher.init(Cipher.ENCRYPT_MODE, publicKey);  
            byte[] enBytes = cipher.doFinal(pwd.getBytes());
            return Base64.encodeToString(enBytes, Base64.DEFAULT).replace("\n", "").replace("\r", "");
		} catch (Exception e) {
			// TODO: handle exception
		}
		return null;
	}
	
	public String aesDecrypt(byte[] encryptBytes, String encryptKey){
		try {
			byte[] raw = encryptKey.getBytes();
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            ByteBuffer byteBuffer = ByteBuffer.allocate(16);
            byteBuffer.put("37degree".getBytes());
            IvParameterSpec iv = new IvParameterSpec(byteBuffer.array());
            cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);
            try {
                byte[] original = cipher.doFinal(encryptBytes);
                String originalString = new String(original);
                return originalString;
            } catch (Exception e) {
            	e.printStackTrace();
                return null;
            }
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public static String byte2HexStr(byte[] b) 
    { 
        String stmp=""; 
        StringBuilder sb = new StringBuilder(""); 
        for (int n=0;n<b.length;n++) 
        { 
            stmp = Integer.toHexString(b[n] & 0xFF); 
            sb.append((stmp.length()==1)? "0"+stmp : stmp); 
            sb.append(" "); 
        } 
        return sb.toString().toUpperCase().trim(); 
    }
	
	
}