package com.zhuge.push.msg;


import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONObject;

import com.zhuge.sys.services.SysUtils;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;


public class ConnectionManager {
    
	private String did;
	public Socket socket;
	private DataInputStream inputWriter;
	private DataOutputStream outWriter;
	private long seq = 0;
	public boolean isLogin = false;
	private final static int CONN_TIMEOUT = 30000;
	private final static int READ_TIMEOUT = 60000;
	private final static int RESULT_TIMEOUT = 20000;
	private BlockingQueue<byte[]> requestQueue = new LinkedBlockingQueue<>();
	public boolean readStop = false;
	public boolean executeStop = false;
	public Thread readThread;
	public Thread executeThread;
	private HashMap<Long, JSONObject> resultMap = new HashMap<>();
	private Context context;
	
	public ConnectionManager(Context context, String did){
		this.did = did;
		this.context = context;
	}
	
	
	/**
	 * 获取连接字符串
	 * @return 连接字符串
	 */
	private String getConnectString(){
		if (this.did != null) {
			try {
				String url = "http://apipool.37degree.com/open/?method=setting_srv.srv_list_get&did="+this.did;
				HttpClient httpclient = new DefaultHttpClient();
			    HttpResponse response = httpclient.execute(new HttpGet(url));
			    StatusLine statusLine = response.getStatusLine();
			    if(statusLine.getStatusCode() == HttpStatus.SC_OK){
			        ByteArrayOutputStream out = new ByteArrayOutputStream();
			        response.getEntity().writeTo(out);
			        out.close();
			        String responseString = out.toString();
			        JSONObject jsonObject = new JSONObject(responseString);
			        if (jsonObject.getInt("return_code") == 0) {
						JSONObject dataObject = jsonObject.getJSONObject("data");
						JSONArray serverArray = dataObject.getJSONArray("servers");
						if (serverArray.length() > 0) {
							return (String)serverArray.get(new Random().nextInt(serverArray.length()));
						}
					}
			        return responseString;
			    } else{
			        response.getEntity().getContent().close();
			    }
			} catch (Exception e) {
				//e.printStackTrace();
			}
			
		}
		return null;		
	}
	
	/**
	 * 建立socket连接
	 * @return
	 */
	public boolean buildConnection(){
		try {
			String serverString = getConnectString();
			if (serverString != null) {
				String[] serverInfo = serverString.split(":");				
				try {
					this.socket = new Socket();
					this.socket.connect(new InetSocketAddress(serverInfo[0], Integer.parseInt(serverInfo[1])), CONN_TIMEOUT);
					this.socket.setKeepAlive(true);
					this.socket.setSoTimeout(READ_TIMEOUT);
					this.inputWriter = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
					this.outWriter = new DataOutputStream(socket.getOutputStream());
					return true;
				} catch (Exception e) {
					//e.printStackTrace();
				}
			}
		} catch (Exception e) {
			//e.printStackTrace();
		}
		
		return false;
	}
	

	
	/**
	 * 发送socket请求
	 * @param info
	 * @return
	 */
	private  boolean sendRequest(byte[] info){
		try {
			this.outWriter.write(info);
			return true;
		} catch (SocketException e) {
			try {
				readStop = true;
				executeStop = true;
				socket.close();
			} catch (Exception e2) {
			}
		} catch (Exception e) {
			//e.printStackTrace();
		}
		return false;
		
	}
	
	/**
	 * 登录
	 * @return 是否提交请求成功
	 */
	public boolean login(){
		try {
			long presentSeq = getSeq();
			byte[] byteInfo = MessageHandler.getLoginRequest(did, presentSeq);
			requestQueue.put(byteInfo);
			long beginTime = System.currentTimeMillis();
			ZhugePushConfig.echo("service 登录"+presentSeq);
			while(socket != null && !socket.isClosed()){
				JSONObject result = resultMap.get(presentSeq);
				if(result != null){
					resultMap.remove(presentSeq);
					if(result.getInt("ret") == 0){
						isLogin = true;
						return true;
					}
					ZhugePushConfig.echo("service 登录"+"结果错误");
					return false;
				}else {
					if ((System.currentTimeMillis() - beginTime) > RESULT_TIMEOUT) {
						ZhugePushConfig.echo("service 登录"+"超时");
						break;
					}
					try {
						Thread.sleep(300);
					} catch (Exception e) {
					}
				}
			}		
		} catch (Exception e) {
			//e.printStackTrace();
		}
		return false;
	}
	
	/**
	 * 登录
	 * @return 确认消息已读
	 */
	public boolean markMsg(String appId, String mid){
		try {
			long presentSeq = getSeq();
			byte[] byteInfo = MessageHandler.getMarkReadRequest(appId, mid, presentSeq);
			requestQueue.put(byteInfo);		
		} catch (Exception e) {
			//e.printStackTrace();
		}
		return false;
	}
	
	
	/**
	 * 获取clientid
	 * @return 是否提交请求成功
	 */
	public String getClientId(String appKey){
		try {
			long presentSeq = getSeq();
			byte[] byteInfo = MessageHandler.getClientIdRequest(appKey, presentSeq);
			requestQueue.put(byteInfo);
			long beginTime = System.currentTimeMillis();
			while (socket != null && !socket.isClosed()) {
				JSONObject result = resultMap.get(presentSeq);
				if(result != null){
					resultMap.remove(presentSeq);
					return result.getString("cid");
				}else {
					if ((System.currentTimeMillis() - beginTime) > RESULT_TIMEOUT) {
						break;
					}
					try {
						Thread.sleep(300);
					} catch (Exception e) {
					}
				}
			}
		} catch (Exception e) {
		}
		return null;
	}
	
	public boolean isOnline(){
		try {
			long presentSeq = getSeq();
			requestQueue.put(MessageHandler.sendHeartbeat(presentSeq));
			long beginTime = System.currentTimeMillis();
			while (socket != null && !socket.isClosed()) {
				JSONObject result = resultMap.get(presentSeq);
				if(result != null){
					resultMap.remove(presentSeq);
					return true;
				}else {
					if ((System.currentTimeMillis() - beginTime) > RESULT_TIMEOUT) {
						break;
					}
					try {
						Thread.sleep(300);
					} catch (Exception e) {
					}
				}
			}
		} catch (Exception e) {
			//e.printStackTrace();
		}
		isLogin = false;
		return false;
	}
	
	/**
	 * 获取包序列号
	 * @return
	 */
	private synchronized long getSeq() {
		this.seq += 1;
		return seq;
	}


	/**
	 * 获取登录状态
	 * @return
	 */
	public boolean getLoginStatus(){
		return this.isLogin;
	}
	
	/**
	 * 读取服务器回复
	 * @return 回复的字符串
	 */
	private  JSONObject getResponse(){
		try {
			byte[] headers = new byte[8];
			this.inputWriter.read(headers);
			byte[] typelen = new byte[2];
			byte[] totallen = new byte[4];
			for (int i = 2; i < 4; i++) {
				typelen[i-2] = headers[i];
			}
			ByteBuffer typeBuffer = ByteBuffer.wrap(typelen);
			typeBuffer.order(ByteOrder.BIG_ENDIAN);
		    short type_len = typeBuffer.getShort();
			for (int i = 4; i < 8; i++) {
				totallen[i-4] = headers[i];
			}
			ByteBuffer totalBuffer = ByteBuffer.wrap(totallen);
			totalBuffer.order(ByteOrder.BIG_ENDIAN);
		    int response_len = totalBuffer.getInt();
		    if (response_len == 0) {
				return null;
			}
		    byte[] body = new byte[response_len-8];
		    this.inputWriter.read(body);
		    ByteBuffer bodyBuffer = ByteBuffer.wrap(body);
		    bodyBuffer.order(ByteOrder.BIG_ENDIAN);
		    bodyBuffer.put(body);
		    String response = "";
		    if(type_len == 0x2000 && MessageHandler.ENCRYPT == 1){
		    	response = new EncryptUtils("AES/CBC/NoPadding").aesDecrypt(bodyBuffer.array(), MessageHandler.privateKey);
		    }else {
		    	response = new String(bodyBuffer.array());
			}
		    if(response.startsWith("{")){
		    	JSONObject returnObject = new JSONObject(response);
			    returnObject.put("msgtype", type_len);
			    return returnObject;
		    }		    
		} catch (Exception e) {
			//e.printStackTrace();
			try {
				ZGPush.getInstance().ping(context);
			} catch (Exception e2) {
				//e.printStackTrace();
			}
		}
		return null;
	}
	
	/**
	 * 消息处理类
	 * @param msgObject
	 */
	private void msgDealer(JSONObject msgObject){
		if (msgObject == null) {
			return;
		}
		try {
			int typeLen = msgObject.getInt("msgtype");
			switch (typeLen) {			
			case 0x1001:
				ZhugePushConfig.echo("service 登录结果"+msgObject.getLong("seq"));
				resultMap.put(msgObject.getLong("seq"), msgObject);
				break;
			case 0x1003:
				resultMap.put(msgObject.getLong("seq"), msgObject);
				break;
			case 0x1007:
				resultMap.put(msgObject.getLong("seq"), msgObject);
				break;
			case 0x2000:
				//resultMap.put(msgObject.getLong("seq"), msgObject);
				distributeMsg(msgObject);
				break;
			default:
				break;
			}
		} catch (Exception e) {
			//e.printStackTrace();
		}
		
	}
	
	public void distributeMsg(JSONObject msgObject){
		try {
			byte[] confirmRequest = MessageHandler.confirmMsg(msgObject.getString("id"), msgObject.getInt("ack_type"), msgObject.getString("router"), msgObject.getString("appid"));
			requestQueue.put(confirmRequest);
			Bundle bundle = getBundle(msgObject);
			String pkg = bundle.getString("pkg");
			if (bundle != null) {
				Intent intent = new Intent(pkg+".msg");
				intent.putExtra("msg", bundle);
				context.sendBroadcast(intent);
			}
		} catch (Exception e) {
			//e.printStackTrace();
		}
		
	}
	
	/**
	 * 执行任务队列
	 */
	public Thread executeQueue(){
		executeStop = false;
		if (executeThread == null) {
			executeThread = new Thread(new Runnable() {
				
				@Override
				public void run() {
					
					while (!executeStop) {
						try {
							byte[] request = requestQueue.take();
							boolean result = false;
							while (socket != null && !socket.isClosed() && !result) {
								result = sendRequest(request);
								if (!SysUtils.isNetworkAvailable(context)) {
									ZGPush.getInstance().destroy(context);
									break;
								}
							}
						} catch (Exception e) {
							//e.printStackTrace();
						}
						
					}
				}
			});
			return executeThread;
		}
		return executeThread;
	}
	
	/**
	 * 消息处理
	 */
	public Thread dealingMsg(){
		readStop = false;
		if (readThread == null) {
			readThread = new Thread(new Runnable() {
				
				@Override
				public void run() {
					while (!readStop && !socket.isClosed()) {
						try {
							if (!SysUtils.isNetworkAvailable(context)) {
								ZGPush.getInstance().destroy(context);
								break;
							}
							JSONObject jsonObject = getResponse();
							msgDealer(jsonObject);
						} catch (Exception e) {
							//e.printStackTrace();
						}
					}
				}
			});
			return readThread;
		}
		return readThread;
	}
	
	public Bundle getBundle(JSONObject jsonObject){
		try {
			if (jsonObject != null && jsonObject.getString("alert") != null) {
				JSONObject androidObject = new JSONObject(jsonObject.getString("alert"));
				Bundle bundle = new Bundle();
				bundle.putString("mid", jsonObject.getString("id"));
				bundle.putString("appid", jsonObject.getString("appid"));
				bundle.putString("title", androidObject.getString("title"));
				bundle.putString("pkg", androidObject.getString("pkg"));
				bundle.putString("content", androidObject.getString("alert"));
				bundle.putBoolean("screen", androidObject.getJSONObject("attr").getBoolean("screen"));
				bundle.putBoolean("ring", androidObject.getJSONObject("attr").getBoolean("ring"));
				bundle.putBoolean("vibrate", androidObject.getJSONObject("attr").getBoolean("vibrate"));
				bundle.putInt("noticetype", androidObject.getJSONObject("attr").getInt("noticetype"));
				bundle.putInt("flag", androidObject.getJSONObject("attr").getJSONObject("clickevent").getInt("flag"));
				bundle.putString("page", androidObject.getJSONObject("attr").getJSONObject("clickevent").getString("value"));
				bundle.putString("custom", androidObject.getJSONObject("attr").getJSONArray("parameters").toString());
				return bundle;
			}
		} catch (Exception e) {
			//e.printStackTrace();
		}
		
		return null;
	}
	
	public  void halt(){
		try {
			executeStop = true;
			readStop = true;
			inputWriter.close();
			outWriter.close();
			socket.close();
		} catch (Exception e) {
			//e.printStackTrace();
		}
	}
	
}


