package com.zhuge.push.broadcastrecievers;


import com.zhuge.push.msg.ZGPush;
import com.zhuge.push.msg.ZhugePushConfig;
import com.zhuge.sys.services.SysUtils;

import android.app.AlertDialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.TaskStackBuilder;
import android.view.WindowManager;

public class UserReciever extends BroadcastReceiver {
	public static final String RECIEVE = ".recieve";
	public static final String PRESENT = "android.intent.action.USER_PRESENT";
	public static final String MSG = ".msg";

	@Override
	public void onReceive(Context context, Intent intent) {
		String action = intent.getAction();
		if (action.equals(context.getPackageName()+RECIEVE)) {
			try {
				String clientId = intent.getStringExtra("cid");
				ZhugePushConfig.echo(clientId+":cid");
				if (clientId != null) {
					SharedPreferences sharedPreferences = context.getSharedPreferences(ZhugePushConfig.TAG, Context.MODE_PRIVATE);
					sharedPreferences.edit().putString(ZhugePushConfig.CID, clientId).commit();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}			
		} else if (action.equals(PRESENT) || action.equals(ConnectivityManager.CONNECTIVITY_ACTION)) {
			try {
				if (SysUtils.isNetworkAvailable(context)) {
					ZGPush.getInstance().initialize(context);
				}else {
					ZGPush.getInstance().destroy(context);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}else if (action.equals(context.getPackageName()+MSG)) {
			try {
				Bundle msg = intent.getBundleExtra("msg");
				switch (msg.getInt("noticetype")) {
				case 1:
					showNotification(context, msg);
					break;
				case 2:
					showAlert(context, msg);
				default:
					break;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			
		}
	}
	
	public void showAlert(final Context context, final Bundle info){
		AlertDialog.Builder dialog = new AlertDialog.Builder(context)
        .setTitle(info.getString("title"))
        .setMessage(info.getString("content"))
        .setNegativeButton("取消", null)
        .setIcon(SysUtils.getId(context, "drawable", "push"))
        .setPositiveButton("查看", new OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				int flag = info.getInt("flag");
				Intent resultIntent = null;
				markMsg(context, info.getString("appid"), info.getString("mid"));
				switch (flag) {
				case 1:
					resultIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
					break;
				case 2:
					ComponentName comp = new ComponentName(context.getPackageName(),  
							info.getString("page"));
					resultIntent = new Intent();
					resultIntent.setComponent(comp);
					break;
				case 3:
					String url = info.getString("page");
					resultIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
				default:
					break;
				}
				if (resultIntent != null) {
					resultIntent.putExtra("custom", info.getString("custom"));
					resultIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
					context.startActivity(resultIntent);
				}
			}
		});
		AlertDialog mDialog=dialog.create();  
        mDialog.getWindow().setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);//设定为系统级警告，关键  
        mDialog.show();
        if (info.getBoolean("vibrate")) {
        	SysUtils.doVibrate(context);
		}
        if (info.getBoolean("screen")) {
        	SysUtils.doWakeLock(context);
		}
        if (info.getBoolean("ring")) {
        	SysUtils.doRing(context);
		}
	}
	
	public void showNotification(Context context, Bundle info){
		NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context)
			.setContentTitle(info.getString("title"))
			.setContentText(info.getString("content"))
			.setSmallIcon(SysUtils.getId(context, "drawable", "push"));
		Intent resultIntent = null;
		int flag = info.getInt("flag");
		switch (flag) {
		case 1:
			resultIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
			break;
		case 2:
			ComponentName comp = new ComponentName(context.getPackageName(),  
					info.getString("page"));
			resultIntent = new Intent();
			resultIntent.setComponent(comp);
			break;
		case 3:
			String url = info.getString("page");
			resultIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
		default:
			break;
		}
		if (resultIntent != null) {
			resultIntent.putExtra("custom", info.getString("custom"));
			resultIntent.putExtra("appid", info.getString("appid"));
			resultIntent.putExtra("mid", info.getString("mid"));
			TaskStackBuilder stackBuilder = TaskStackBuilder.create(context);
			stackBuilder.addNextIntent(resultIntent);
			PendingIntent resultPendingIntent =
			        stackBuilder.getPendingIntent(
			            0,
			            PendingIntent.FLAG_CANCEL_CURRENT
			        );
			mBuilder.setContentIntent(resultPendingIntent);
			Notification notification = mBuilder.build();
			if (info.getBoolean("vibrate")) {
	        	SysUtils.doVibrate(context);
			}
	        if (info.getBoolean("screen")) {
	        	SysUtils.doWakeLock(context);
			}
	        if (info.getBoolean("ring")) {
	        	SysUtils.doRing(context);
			}
	        notification.flags |= Notification.FLAG_AUTO_CANCEL;
			NotificationManager mNotificationManager =
			    (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
			
			mNotificationManager.notify(0, notification);
		}
	}
	
	public static void markMsg(Context context, String aid, String mid){
		Intent serviceIntent = SysUtils.createExplicitFromImplicitIntent(context, new Intent("com.zhuge.push.PushService"), SysUtils.getRunningServicePkg(context), ZhugePushConfig.CLS);
		serviceIntent.putExtra("cmd", ZhugePushConfig.MARK);
		Bundle bundle = new Bundle();
		bundle.putString("appid", aid);
		bundle.putString("mid", mid);
		serviceIntent.putExtra("data", bundle);
		context.startService(serviceIntent);
	}

}
