/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.stat;

import android.content.Context;
import com.zhuge.analysis.stat.ZhugeConfig;
import java.util.HashMap;
import org.json.JSONObject;

public class ZhugeSDK {
    private ZhugeConfig config = new ZhugeConfig();
    private long preSessionEnd = -1L;
    private boolean isInit = false;

    public ZhugeConfig getConfig() {
        ZhugeSDK.getInstance();
        return this.config;
    }

    private ZhugeSDK() {
    }

    public static final ZhugeSDK getInstance() {
        return SingletonHolder.instance;
    }

    public synchronized void init(Context context) {
        this.config.initDevinfo(context);
        this.init(context, this.config.getAppkey(), this.config.getChannel());
    }

    public synchronized void halt() {
        this.preSessionEnd = -1L;
    }

    public synchronized void init(Context context, String appKey, String channel) {
        try {
            this.config.debug(((System.currentTimeMillis() - this.preSessionEnd) / 1000L < (long)this.config.getSessionExceed()) + "-time");
            if ((System.currentTimeMillis() - this.preSessionEnd) / 1000L < (long)this.config.getSessionExceed()) {
                this.config.debug("\u5df2\u7ecf\u521d\u59cb\u5316");
                return;
            }
            this.halt();
            this.config.setAppkey(appKey);
            this.config.setChannel(channel);
            if (this.config.getAppkey().equals("null") || this.config.getChannel().equals("null")) {
                this.config.debug("\u6ca1\u6709\u586b\u5199Appkey\u6216\u8005\u6e20\u9053\u540d");
                return;
            }
            this.config.initDeviceInfo(context);
            if (this.config.getDid() == null) {
                return;
            }
            this.config.initAppinfo(context);
            this.config.debug("\u521d\u59cb\u5316\u6210\u529f\n" + this.config.getInitDebugInfo(context));
            if (this.config.getDid() == null) {
                return;
            }
            if (this.preSessionEnd != -1L && (System.currentTimeMillis() - this.preSessionEnd) / 1000L < (long)this.config.getSessionExceed()) {
                this.config.debug("30s\u5185\u542f\u52a8");
                return;
            }
            this.config.initEvent(context);
            this.isInit = true;
            this.updateSessionEnd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void flush(Context context) {
        try {
            if (this.config.getDid() == null) {
                return;
            }
            this.updateSessionEnd();
            this.config.completeLastSession(context);
            this.config.sendData();
            this.config.stopUpload();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void updateSessionEnd() {
        this.preSessionEnd = System.currentTimeMillis();
        this.config.saveSessionEnd(this.preSessionEnd);
    }

    public synchronized void setDebug(boolean debug) {
        this.config.setDebug(debug);
    }

    public synchronized void disableAccounts(boolean accounts) {
        this.config.setDisableAccounts(accounts);
    }

    public synchronized void disablePhoneNumber(boolean phone) {
        this.config.setDisablePhonenum(phone);
    }

    public synchronized void onEvent(Context context, String event_name, JSONObject kv) {
        if (this.config.getDid() == null) {
            return;
        }
        this.config.onCustomEvent(context, event_name, kv);
    }

    public synchronized void onEvent(Context context, String event_name, HashMap<String, Object> kv) {
        if (this.config.getDid() == null) {
            return;
        }
        this.config.onCustomEvent(context, event_name, kv);
    }

    public synchronized void onEvent(Context context, String event_name) {
        if (this.config.getDid() == null) {
            return;
        }
        this.config.onCustomEvent(context, event_name);
    }

    public synchronized void identify(Context context, String uid, HashMap<String, Object> kv) {
        if (this.config.getDid() == null) {
            return;
        }
        this.config.identifyPerson(context, uid, kv);
    }

    public synchronized void identify(Context context, String uid, JSONObject kv) {
        if (this.config.getDid() == null) {
            return;
        }
        this.config.identifyPerson(context, uid, kv);
    }

    public void setThirdPartyPushUserId(PushChannel channel, String userId) {
        if (null == channel || null == userId) {
            return;
        }
        String chan = channel.toString();
        this.config.channelData(chan, userId);
    }

    private static class SingletonHolder {
        private static final ZhugeSDK instance = new ZhugeSDK();

        private SingletonHolder() {
        }
    }

    public static enum PushChannel {
        JPUSH("jpush"),
        UMENG("umeng"),
        BAIDU("baidu"),
        XINGE("xinge"),
        GETUI("getui");

        private String value;

        private PushChannel(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

