package com.zhuge.analysis.stat;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;

import com.zhuge.analysis.BuildConfig;
import com.zhuge.analysis.util.ZGLogger;

/**
 * SDK常量信息类
 * Created by Omen on 16/6/17.
 */
public class Constants {

    static final String SDK_V = BuildConfig.VERSION_NAME;
    static int UPLOAD_LIMIT_SIZE = 5;
    static long FLUSH_INTERVAL = 5*1000;
    static int MAX_LOCAL_SIZE = 500;
    /**
     * 每天发送事件数
     */
    static  int SEND_SIZE = 500;
    static final boolean ENABLE_SESSION_TRACK = true;//当前默认开启，之后可能关闭st,se事件追踪

    public static String API_PATH = "https://u.zhugeapi.com/apipool";

    public static String API_PATH_BACKUP = "https://ubak.zhugeio.com/upload/";

    public static final String PATH_ENDPOINT = "apipool";
    public static final String BACKUP_PATH_ENDPOINT = "upload";
    /**
     * 会话上次活动时间
     */
    static  String SP_LAST_SESSION_TIME = "ZhugeLastSession";
    /**
     * 今日事件数
     */
    static  String SP_TODAY_COUNT = "Today_total";

    /**
     * 设备信息更新时间
     */
    static  String SP_UPDATE_DEVICE_TIME = "info_ts";

    /**
     * 设备ID
     */
    static  String SP_DID = "zhuge_did";

    /**
     * 用户ID
     */
    static  String SP_CUID = "cuid";

    /**
     * 会话间隔,单位毫秒。
     */
    static  int session_exceed = 30 * 1000;

    static String SP_MODIFY = "zg_update_status";

    static final String SP_USER_DEFINE_DEVICE = "zg_user_device";

    static final String SP_USER_DEFINE_EVENT = "zg_user_event";

    static void configString(StringBuilder stringBuilder) {
        stringBuilder.append("SDK版本: ").append(SDK_V).append("\n")
                .append("触发上传事件数: ").append(UPLOAD_LIMIT_SIZE).append("\n")
                .append("本地最大缓存数: ").append(MAX_LOCAL_SIZE).append("\n")
                .append("每日上传事件数: ").append(SEND_SIZE).append("\n")
                .append("会话间隔: ").append(session_exceed).append("\n");

    }

    static void loadConfig(Context context){
        try {
            String packageName = context.getPackageName();
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(packageName, PackageManager.GET_META_DATA);
            Bundle metaData = applicationInfo.metaData;
            if (null == metaData ){
                metaData = new Bundle();
            }
            session_exceed = (metaData.getInt("com.zhuge.config.SessionInterval",30))*1000; //会话间隔，配置以秒计算
            UPLOAD_LIMIT_SIZE = metaData.getInt("com.zhuge.config.UploadLimit",5); //5条记录上传
            FLUSH_INTERVAL = (metaData.getInt("com.zhuge.config.FlushInterval",5))*1000; //数据上传间隔，默认5秒
            MAX_LOCAL_SIZE = metaData.getInt("com.zhuge.config.MaxLocalSize",500); //本地最大缓存数，默认500
            SEND_SIZE = metaData.getInt("com.zhuge.config.MaxSendSize",500); //每日最大上传数，默认500
        }catch (Exception e){
            ZGLogger.handleException("Zhuge.Constants","读取配置信息出错，将使用默认配置",e);
        }
    }

}
