package com.zhuge.analysis.util;

import android.util.Log;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * 其他工具类
 * Created by Omen on 15/11/9.
 */
public class Utils {
    private static final String TAG = "com.zhuge.Utils";

    /**
     * md5加密
     *
     * @param string 待加密字符
     * @return 加密字符
     */
    public static String md5(String string) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Huh, MD5 should be supported?", e);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Huh, UTF-8 should be supported?", e);
        }

        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 0x10)
                hex.append("0");
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static int getTimeZone() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getRawOffset();
    }

    /**
     * 浅拷贝，能减小一点发生异常的概率
     */
    public static JSONObject cloneJSONObject(final JSONObject obj) {
        if (obj == null) {
            return null;
        }

        // obj.names returns null if the json obj is empty.
        JSONArray nameArray = null;
        try {
            nameArray = obj.names();
        } catch (ArrayIndexOutOfBoundsException e) {
            Log.e(TAG, e.toString());
        }
        int len = (nameArray != null ? nameArray.length() : 0);
        try {
            JSONObject copy = new JSONObject();
            for (int i = 0; i < len; i++) {
                String key = nameArray.optString(i);
                Object value = obj.opt(key);
                StringBuilder builder = new StringBuilder(key);
                builder.insert(0,'_');
                copy.put(builder.toString(),value);
            }
            return copy;
        } catch (JSONException e) {
            Log.e(TAG, e.toString());
            return null;
        }
    }

    public static String timeStamp2Date (long time){
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss",Locale.ENGLISH);
        return dateFormat.format(new Date(time));
    }
}
