package com.zhuge.analysis.util;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;


/**
 * 设备信息管理类
 * Created by kongmiao on 14-10-11.
 */
public class DeviceInfoUtils {

    /**
     * 获取操作系统版本号
     *
     * @return
     */
    public static String getOSVersion() {
        return android.os.Build.VERSION.RELEASE;
    }

    /**
     * 获取生产厂商
     *
     * @return
     */
    public static String getManfacturer() {
        return android.os.Build.MANUFACTURER;
    }

    /**
     * 获取品牌
     *
     * @return
     */
    public static String getBrand() {
        return android.os.Build.BRAND;
    }

    /**
     * 获取设备型号
     *
     * @return
     */
    public static String getDevice() {
        return android.os.Build.MODEL;
    }


    /**
     * 获取分辨率
     *
     * @param context
     * @return
     */
    public static String getResolution(final Context context) {
        // user reported NPE in this method; that means either getSystemService or getDefaultDisplay
        // were returning null, even though the documentation doesn't say they should do so; so now
        // we catch Throwable and return empty string if that happens
        StringBuilder resolution = new StringBuilder();
        try {
            final WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
            final Display display = wm.getDefaultDisplay();
            final DisplayMetrics metrics = new DisplayMetrics();
            display.getMetrics(metrics);
            resolution.append(metrics.heightPixels)
                    .append("x")
                    .append(metrics.widthPixels);
        } catch (Exception e) {
            Log.e("ZhugeSDK", "没有检测到分辨率");
        }
        return resolution.toString();
    }

}
