package com.zhuge.analysis.stat;

import android.content.Context;

import com.zhuge.analysis.util.ZGJSONObject;

import org.json.JSONObject;

import java.util.HashMap;

/**
 * 诸葛统计开放接口
 * Created by jiaokang on 15/11/9.
 */
public class ZhugeSDK{

    //配置信息
    private ZhugeConfig config;

    private EventStore eventStore;


    private static class SingletonHolder {
        private static final ZhugeSDK instance = new ZhugeSDK();
    }


    private ZhugeSDK() {
        config = new ZhugeConfig();
    }

    public static ZhugeSDK getInstance() {
        return SingletonHolder.instance;
    }

    public enum PushChannel {
        JPUSH("jpush"), UMENG("umeng"), XIAOMI("xiaomi"), BAIDU("baidu"), XINGE("xinge"), GETUI("getui");

        private String value;

        PushChannel(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    /**
     * 打开日志，默认关闭。
     */
    public void openLog() {
        config.logEnable = true;
    }

    /**
     * 打开实时调试，默认关闭
     */
    public void openDebug() {
        ZhugeConfig.debug = true;
    }

    public void disableAccounts() {
        config.disableAccounts();
    }

    public void disablePhoneNumber() {
        config.disablePhonenum();
    }

    public void disableAppList() {
        config.disableAppList();
    }

    /**
     * SDK初始化，必须在每个activity的onResume中调用。否则统计数据不准确
     * 调用此接口需在manifests文件中指明ZHUGE_APPKEY与ZHUGE_CHANNEL。
     *
     * @param context 应用上下文
     */
    public void init(Context context) {
        config.initDevInfo(context);
        init(context, config.getAppkey(), config.getAppChannel());
    }

    /**
     * SDK初始化
     *
     * @param context    应用上下文
     * @param appKey     appKey
     * @param appChannel 应用自定义渠道
     */
    public void init(Context context, String appKey, String appChannel) {
        //检查当前是否是重新进入
        if (config.checkSelf(appKey, appChannel)) {
            config.debug("appKey: " + appKey + " ,appChannel: " + appChannel+"\n"+"或许是重新进入");
            return;
        }
        config.preSessionEnd = System.currentTimeMillis();
        config.initGlobalSettingFile(context.getApplicationContext());
        config.setAppkey(appKey);
        config.setAppChannel(appChannel);
        config.initDeviceInfo(context);
        if (config.getDid() == null) {
            return;
        }
        config.initAppinfo(context);
        config.debugInitInfo(context);
        config.debug("会话开始");
        eventStore = EventStore.getInstance(context, config);
        completeLastSession(1);
        startSession();
        initInfo(context.getApplicationContext());
        initAccont(context.getApplicationContext());
        initApplist(context.getApplicationContext());
    }

    @Deprecated
    public void onEvent(Context context, String event_name, JSONObject kv) {
        track(context, event_name, kv);
    }

    @Deprecated
    public void onEvent(Context context, String event_name, HashMap<String, Object> kv) {
        track(context, event_name, kv);
    }

    @Deprecated
    public void onEvent(Context context, String event_name) {
        track(context, event_name);
    }


    public void track(Context context, String event_name, JSONObject kv) {
        if (config.getDid() == null)
            return;
        config.debug("添加事件：\n"+event_name+"\n"+kv.toString());
        ZGJSONObject info = config.customEvent(event_name, kv);
        eventStore.addEventToHandler(info, EventStore.MESSAGE_CUSTOM_EVENT);
    }

    public void track(Context context, String event_name, HashMap<String, Object> kv) {
        track(context, event_name, new JSONObject(kv));
    }

    public void track(Context context, String event_name) {
        if (config.getDid() == null)
            return;
        config.debug("添加事件：\n"+event_name);
        ZGJSONObject info = config.customEvent(event_name, null);
        eventStore.addEventToHandler(info, EventStore.MESSAGE_CUSTOM_EVENT);
    }

    public void identify(Context context, String uid, HashMap<String, Object> kv) {
        identify(context, uid, new JSONObject(kv));
    }

    public void identify(Context context, String uid, JSONObject kv) {
        if (config.getDid() == null)
            return;
        config.debug("标记用户：\n"+uid+"\n"+kv.toString());
        ZGJSONObject info = config.identifyPerson(uid, kv);
        eventStore.addEventToHandler(info, EventStore.MESSAGE_IDENTIFY_EVENT);
    }

    public void flush(Context context ){
        if (config.getDid() == null){
            return;
        }
        ZGJSONObject info = config.completeLastSession(2, eventStore.getEventCount());
        if (null == info)
            return;
        eventStore.addEventToHandler(info,EventStore.MESSAGE_FLUSH);

    }

    public String getDid(){
        return config.getDid();
    }

    /**
     * channel 参数使用ZhugeSDK.PushChannel获得
     *
     * @param channel
     *            要关联的第三方渠道名称，PushChannle枚举类中的一种
     * @param userId
     *            客户端ID
     */
    public void setThirdPartyPushUserId(PushChannel channel, String userId) {
        if (null == channel || null == userId) {
            return;
        }
        String chan = channel.toString();
        ZGJSONObject info = config.channelData(chan, userId);
        if (null != info){
            eventStore.addEventToHandler(info, EventStore.MESSAGE_PUSH_MSG);
        }
    }

    public void onMsgReaded(PushChannel channel, Object t) {
        ZGJSONObject info = config.parseMid(ZhugeConfig.MSG_READ, channel, t);
        if (null != info){
            eventStore.addEventToHandler(info, EventStore.MESSAGE_PUSH_MSG);
        }
    }

    public void onMsgRecved(PushChannel channel, Object t) {
        ZGJSONObject info = config.parseMid(ZhugeConfig.MSG_RECV, channel, t);
        if (null != info){
            eventStore.addEventToHandler(info, EventStore.MESSAGE_PUSH_MSG);
        }
    }


    private void initApplist(Context context) {
        ZGJSONObject info = config.initApplist(context);
        if (null == info)
            return;
        eventStore.addEventToHandler(info, EventStore.MESSAGE_INIT_APPLIST);
    }

    private void initAccont(Context context) {
        ZGJSONObject info = config.initAcs(context);
        if (null == info)
            return;
        eventStore.addEventToHandler(info, EventStore.MESSAGE_INIT_ACCOUNTS);
    }

    private void initInfo(Context context) {
        ZGJSONObject info = config.initInfo(context);
        if (null == info)
            return;
        eventStore.addEventToHandler(info, EventStore.MESSAGE_INIT_INFO);
    }

    private void startSession() {
        ZGJSONObject info = config.startSession();
        eventStore.addEventToHandler(info, EventStore.MESSAGE_START_SESSION);
    }

    private void completeLastSession(int state) {
        ZGJSONObject info = config.completeLastSession(state, eventStore.getEventCount());
        if (null == info)
            return;
        eventStore.addEventToHandler(info, EventStore.MESSAGE_COMPLETE_SESSION);
    }

}
