/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.util_svs;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.zhuge.analysis.stat.ZhugeConfig;
import com.zhuge.analysis.stat.ZhugeSDK;
import com.zhuge.analysis.sys_svs.ActivityServicesUtils;
import com.zhuge.analysis.sys_svs.ConnectivityUtils;
import com.zhuge.analysis.sys_svs.TimeUtils;
import com.zhuge.analysis.util_svs.ZGJSONObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventStore {
    private SharedPreferences zhugeSettings;
    private static final String EVENT_KEY = "events";
    private static final String TOTALDAY_KEY = "total";
    private static final String DELIMITER = "===";
    private static final String REQUEST_TIME = "rTime";
    private static ExecutorService executor_;
    private static ExecutorService debugExecutor;
    public ScheduledExecutorService timerService_;
    private ScheduledFuture timerFuture;
    private static ActivityServicesUtils activityServicesUtils;
    private static ConnectivityUtils connectivityUtils;
    private int todayTotal = 0;
    private static final int ALLEVENTS = 0;
    private static final int SPLITEVENTS = 1;

    private SharedPreferences getZhugeSettings() {
        return this.zhugeSettings;
    }

    private synchronized void ensureExecutor() {
        if (executor_ == null) {
            executor_ = Executors.newSingleThreadExecutor();
        }
    }

    private synchronized void ensureDebugExecutor() {
        if (debugExecutor == null) {
            debugExecutor = Executors.newCachedThreadPool();
        }
    }

    public int getTodayTotal() {
        return this.todayTotal;
    }

    public EventStore(Context context, String pf, String spName) {
        if (null == connectivityUtils) {
            connectivityUtils = new ConnectivityUtils(context);
        }
        this.zhugeSettings = context.getSharedPreferences(spName, 0);
        this.startUploadService(context);
        String todayInfo = this.getZhugeSettings().getString(TOTALDAY_KEY, "");
        if ("".equals(todayInfo)) {
            this.todayTotal = 0;
        } else {
            String[] tiInfo = todayInfo.split("\\|");
            this.todayTotal = System.currentTimeMillis() / 1000L / 86400L - (long)Integer.parseInt(tiInfo[0]) > 0L ? 0 : Integer.parseInt(tiInfo[1]);
        }
    }

    public boolean stopTimeService() {
        try {
            this.timerFuture.cancel(false);
            this.timerService_.shutdown();
        }
        catch (Exception e) {
            ZhugeSDK.getInstance().getConfig().debug("\u7ebf\u7a0b\u6c60\u5173\u95ed\u5931\u8d25");
        }
        return false;
    }

    private synchronized void updateEventCount() {
        this.getZhugeSettings().edit().putString(TOTALDAY_KEY, System.currentTimeMillis() / 1000L / 86400L + "|" + this.todayTotal).commit();
    }

    private synchronized void saveRequestTime(long time) {
        this.getZhugeSettings().edit().putLong(REQUEST_TIME, time).apply();
    }

    public synchronized void addEvent(ZGJSONObject event) {
        List<ZGJSONObject> events = this.eventsList(0);
        events.add(event);
        this.getZhugeSettings().edit().putString(EVENT_KEY, EventStore.joinEvents(events, DELIMITER)).commit();
    }

    private String[] events(int state) {
        String joinedEventsStr = this.getZhugeSettings().getString(EVENT_KEY, "");
        String[] allEvents = joinedEventsStr.length() == 0 ? new String[]{} : joinedEventsStr.split(DELIMITER);
        switch (state) {
            case 0: {
                return allEvents;
            }
            case 1: {
                if (allEvents.length > 100) {
                    String[] events = new String[100];
                    System.arraycopy(allEvents, 0, events, 0, 100);
                    return events;
                }
                return allEvents;
            }
        }
        return allEvents;
    }

    public synchronized void removeEvents(Collection<ZGJSONObject> eventsToRemove) {
        if (eventsToRemove != null && eventsToRemove.size() > 0) {
            List<ZGJSONObject> events = this.eventsList(0);
            if (null == events) {
                return;
            }
            if (events.removeAll(eventsToRemove)) {
                this.getZhugeSettings().edit().putString(EVENT_KEY, EventStore.joinEvents(events, DELIMITER)).commit();
                ZhugeSDK.getInstance().getConfig().debug("\u672c\u5730\u6570\u636e\u5220\u9664\u6210\u529f");
            }
        }
    }

    public List<ZGJSONObject> eventsList(int states) {
        String[] array = this.events(states);
        ArrayList<ZGJSONObject> events = new ArrayList<ZGJSONObject>(array.length);
        for (String s : array) {
            try {
                ZGJSONObject event = new ZGJSONObject(s);
                events.add(event);
            }
            catch (JSONException ignored) {
                // empty catch block
            }
        }
        Collections.sort(events, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject e1, JSONObject e2) {
                Long delta = e1.optLong("ts", -1L) - e2.optLong("ts", -1L);
                return delta.intValue();
            }
        });
        return events;
    }

    static String joinEvents(Collection<JSONObject> collection, String delimiter) {
        ArrayList<String> strings = new ArrayList<String>();
        for (JSONObject e : collection) {
            strings.add(e.toString());
        }
        return EventStore.join(strings, delimiter);
    }

    static String joinEvents(List<ZGJSONObject> collection, String delimiter) {
        ArrayList<String> strings = new ArrayList<String>();
        for (JSONObject jSONObject : collection) {
            strings.add(jSONObject.toString());
        }
        return EventStore.join(strings, delimiter);
    }

    static String join(Collection<String> collection, String delimiter) {
        String s;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String s2 : collection) {
            builder.append(s2);
            if (++i >= collection.size()) continue;
            builder.append(delimiter);
        }
        try {
            s = builder.toString();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return null;
        }
        return s;
    }

    synchronized void clear() {
        SharedPreferences.Editor prefsEditor = this.getZhugeSettings().edit();
        prefsEditor.remove(EVENT_KEY);
        prefsEditor.commit();
    }

    public String getEventsString() {
        return this.getZhugeSettings().getString(EVENT_KEY, "");
    }

    public synchronized void startUploadService(final Context context) {
        if (this.timerService_ == null) {
            this.timerService_ = Executors.newSingleThreadScheduledExecutor();
        }
        this.timerFuture = this.timerService_.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                block6: {
                    String presentPackage;
                    if (activityServicesUtils == null) {
                        activityServicesUtils = new ActivityServicesUtils(context);
                    }
                    if (!(presentPackage = activityServicesUtils.getForegroundPackage()).contains(context.getPackageName())) {
                        try {
                            ZhugeSDK.getInstance().getConfig().debug("\u4f1a\u8bdd\u6682\u505c");
                            Thread.sleep(20000L);
                            presentPackage = activityServicesUtils.getForegroundPackage();
                            if (!presentPackage.contains(context.getPackageName())) {
                                ZhugeSDK.getInstance().getConfig().completeLastSession(context, 0);
                                EventStore.this.send(true);
                                ZhugeSDK.getInstance().getConfig().debug("\u4f1a\u8bdd\u7ed3\u675f");
                                EventStore.this.timerService_.schedule(new Runnable(){

                                    @Override
                                    public void run() {
                                        EventStore.this.stopTimeService();
                                    }
                                }, 1L, TimeUnit.SECONDS);
                                break block6;
                            }
                            ZhugeSDK.getInstance().getConfig().debug("\u4f1a\u8bdd\u7ee7\u7eed");
                            ZhugeSDK.getInstance().updateSessionEnd();
                            EventStore.this.send(false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        ZhugeSDK.getInstance().updateSessionEnd();
                        EventStore.this.send(false);
                    }
                }
            }
        }, ZhugeSDK.getInstance().getConfig().getPeriodTime(), ZhugeSDK.getInstance().getConfig().getPeriodTime(), TimeUnit.SECONDS);
    }

    public void send(final boolean flush) {
        try {
            this.ensureExecutor();
            executor_.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (connectivityUtils.getNetworkType() == -100) {
                            ZhugeSDK.getInstance().getConfig().debug("\u7f51\u7edc\u72b6\u6001\u4e0d\u4f73|" + connectivityUtils.getNetworkType());
                            return;
                        }
                        List<ZGJSONObject> eventList = EventStore.this.eventsList(1);
                        if (eventList.size() <= 0) {
                            return;
                        }
                        if (EventStore.this.todayTotal > ZhugeSDK.getInstance().getConfig().getUpload_per_day()) {
                            ZhugeSDK.getInstance().getConfig().debug("\u6570\u636e\u8d85\u8fc7\u6bcf\u65e5\u4e0a\u4f20\u7684\u9650\u5236\uff1a" + EventStore.this.todayTotal);
                            return;
                        }
                        if (!flush && eventList.size() < ZhugeSDK.getInstance().getConfig().getLocalMax()) {
                            return;
                        }
                        JSONObject jsonObject = EventStore.this.sendData(eventList);
                        boolean send_status = EventStore.this.requestAPI(jsonObject);
                        if (send_status) {
                            ZhugeSDK.getInstance().getConfig().debug("\u4e0a\u4f20\u6570\u636e\u6210\u529f");
                            EventStore.this.todayTotal += eventList.size();
                            if (!ZhugeSDK.getInstance().getConfig().isDebug()) {
                                EventStore.this.updateEventCount();
                            }
                            EventStore.this.removeEvents(eventList);
                        }
                    }
                    catch (Exception e) {
                        ZhugeSDK.getInstance().getConfig().debug("\u53d1\u9001\u6570\u636e\u7ebf\u7a0b\u51fa\u9519");
                    }
                }
            });
        }
        catch (Exception e) {
            ZhugeSDK.getInstance().getConfig().debug("\u4e0a\u4f20\u8fc7\u7a0b\u51fa\u9519");
        }
    }

    private synchronized JSONObject sendData(List<ZGJSONObject> events) {
        try {
            String cuid;
            JSONObject postData = new JSONObject();
            ZhugeConfig tmpConfig = ZhugeSDK.getInstance().getConfig();
            postData.put("ak", (Object)tmpConfig.getAppkey());
            postData.put("sdkv", (Object)"v1.5.1");
            postData.put("sdk", (Object)"and");
            postData.put("did", (Object)tmpConfig.getDid());
            postData.put("cn", (Object)tmpConfig.getChannel());
            long lTime = this.getZhugeSettings().getLong(REQUEST_TIME, 0L);
            if (lTime != 0L) {
                postData.put("lt", lTime);
            }
            if (ZhugeSDK.getInstance().getConfig().isDebug()) {
                postData.put("debug", 1);
            }
            if ((cuid = this.getZhugeSettings().getString("cuid", null)) != null) {
                postData.put("cuid", (Object)cuid);
            }
            long now_t = System.currentTimeMillis();
            postData.put("ts", (Object)TimeUtils.formatTime(now_t));
            postData.put("type", (Object)"statis");
            JSONArray jsonArray = new JSONArray();
            for (ZGJSONObject zgjsonObject : events) {
                jsonArray.put((Object)zgjsonObject);
            }
            postData.put("data", (Object)jsonArray);
            return postData;
        }
        catch (Exception e) {
            ZhugeSDK.getInstance().getConfig().debug("\u6570\u636e\u7ec4\u88c5\u51fa\u9519" + e.getMessage());
            return null;
        }
    }

    private boolean requestAPI(JSONObject postData) {
        try {
            String path = "http://apipool.37degree.com/APIPOOL/";
            DefaultHttpClient client = new DefaultHttpClient();
            client.getParams().setParameter("http.connection.timeout", (Object)ZhugeSDK.getInstance().getConfig().getConnectTimeout());
            client.getParams().setParameter("http.socket.timeout", (Object)ZhugeSDK.getInstance().getConfig().getReadTimeout());
            HttpPost httpPost = new HttpPost(path);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("method", "event_statis_srv.upload"));
            params.add(new BasicNameValuePair("compress", "1"));
            params.add(new BasicNameValuePair("event", Base64.encodeToString((byte[])this.compress(postData.toString().getBytes()), (int)0).replace("\r", "").replace("\n", "")));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "utf-8"));
            long befor = System.currentTimeMillis();
            HttpResponse response = client.execute((HttpUriRequest)httpPost);
            long resp = System.currentTimeMillis();
            this.saveRequestTime(resp - befor);
            if (200 == response.getStatusLine().getStatusCode()) {
                boolean success;
                int c;
                BufferedInputStream responseStream = new BufferedInputStream(response.getEntity().getContent());
                ByteArrayOutputStream responseData = new ByteArrayOutputStream(1024);
                while ((c = responseStream.read()) != -1) {
                    responseData.write(c);
                }
                JSONObject responseDict = new JSONObject(responseData.toString("UTF-8"));
                boolean bl = success = responseDict.optInt("return_code") == 0;
                if (success) {
                    return true;
                }
                ZhugeSDK.getInstance().getConfig().debug("\u8bf7\u6c42\u670d\u52a1\u5668\u5931\u8d25\uff0c\u670d\u52a1\u5668\u54cd\u5e94\u7801" + responseDict.optInt("return_code"));
            }
        }
        catch (Exception e) {
            ZhugeSDK.getInstance().getConfig().debug("\u8fde\u63a5\u670d\u52a1\u5668\u51fa\u9519" + e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compress(byte[] data) {
        byte[] output = new byte[]{};
        Deflater compresser = new Deflater();
        compresser.reset();
        compresser.setInput(data);
        compresser.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        try {
            int dataLen = data.length;
            byte[] buf = new byte[dataLen + 1];
            while (!compresser.finished()) {
                int i = compresser.deflate(buf);
                bos.write(buf, 0, i);
            }
            output = bos.toByteArray();
        }
        catch (Exception e) {
            output = data;
            e.printStackTrace();
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        compresser.end();
        return output;
    }

    public void sendDataImmediately(ZGJSONObject data) {
        final ArrayList<ZGJSONObject> eventList = new ArrayList<ZGJSONObject>(1);
        eventList.add(data);
        this.ensureDebugExecutor();
        debugExecutor.submit(new Runnable(){

            @Override
            public void run() {
                JSONObject jsonObject = EventStore.this.sendData(eventList);
                boolean send_status = EventStore.this.requestAPI(jsonObject);
                if (send_status) {
                    ZhugeSDK.getInstance().getConfig().debug("\u4e0a\u4f20\u6570\u636e\u6210\u529f");
                }
            }
        });
    }
}

