package com.zhuge.analysis.util_svs;

import android.util.Log;

import com.zhuge.analysis.stat.ZhugeConfig;
import com.zhuge.analysis.stat.ZhugeSDK;

import org.json.JSONObject;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

/**
 * 更新配置
 * Created by kongmiao on 14-10-11.
 */
public class UpdateOnlineConfig {

    public static JSONObject getServerConfig() {
        JSONObject jsonObject = null;
        try {
            String urlStr = "http://zhugeio.com/config.jsp?appkey=" + ZhugeSDK.getInstance().getConfig().getAppkey() + "&did=" + ZhugeSDK.getInstance().getConfig().getDid();
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(ZhugeSDK.getInstance().getConfig().getConnectTimeout());
            conn.setReadTimeout(ZhugeSDK.getInstance().getConfig().getReadTimeout());
            conn.setUseCaches(false);
            conn.setDoInput(true);
            // 不能设置为true
            conn.setDoOutput(false);
            conn.connect();
            BufferedInputStream responseStream = new BufferedInputStream(conn.getInputStream());
            ByteArrayOutputStream responseData = new ByteArrayOutputStream(1024);
            int c;
            while ((c = responseStream.read()) != -1) {
                responseData.write(c);
            }
            // response code has to be 2xx to be considered a success
            boolean success = true;
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection httpConn = (HttpURLConnection) conn;
                int responseCode = httpConn.getResponseCode();
                success = responseCode >= 200 && responseCode < 300;
                if (!success) {
                    ZhugeSDK.getInstance().getConfig().debug("获取在线配置，HTTP返回码是" + responseCode);
                }
            }
            // HTTP response code was good, check response JSON contains {"result":"Success"}
            if (success) {
                JSONObject responseDict = new JSONObject(responseData.toString("UTF-8"));
                success = responseDict.optString("result").equalsIgnoreCase("success");
                if (success) {
                    jsonObject = responseDict;
                }
                if (!success) {
                    Log.w(ZhugeConfig.TAG, "获取在线配置时，返回错误，结果为" + responseData.toString("UTF-8"));
                } else {
                    Log.d(ZhugeConfig.TAG, "获取在线配置成功");

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            ZhugeSDK.getInstance().getConfig().debug("获取在线配置错误，检查是否没有网络或者权限INTERNET," + e.getLocalizedMessage());
        }
        return jsonObject;
    }

}
