package com.zhuge.analysis.stat;

import android.content.Context;

import com.zhuge.analysis.sys_svs.ActivityServicesUtils;

import org.json.JSONObject;

import java.util.HashMap;

/**
 * SDK核心控制类 Created by kongmiao on 14-10-11.
 */
public class ZhugeSDK {

    /**
     * 规则配置
     */
    private ZhugeConfig config;

    public enum PushChannel {
        JPUSH("jpush"), UMENG("umeng"), XIAOMI("xiaomi"), BAIDU("baidu"), XINGE("xinge"), GETUI("getui");

        private String value;

        PushChannel(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public ZhugeConfig getConfig() {
        getInstance();
        return config;
    }

    private long preSessionEnd = -1;

    private static class SingletonHolder {
        private static final ZhugeSDK instance = new ZhugeSDK();
    }

    private ZhugeSDK() {
        config = new ZhugeConfig();
    }

    public static ZhugeSDK getInstance() {
        return SingletonHolder.instance;
    }

    /**
     * 初始化
     *
     * @param context
     *            context
     */
    public synchronized void init(Context context) {
        config.initDevInfo(context);
        init(context, config.getAppkey(), config.getChannel());
    }

    public synchronized void halt() {
        preSessionEnd = -1;
    }

    /**
     * 初始化
     *
     * @param context
     *            context
     * @param appKey
     *            appkey
     * @param channel
     *            渠道名
     */
    public synchronized void init(Context context, String appKey, String channel) {
        try {
            if (((System.currentTimeMillis() - preSessionEnd) / 1000 < config.getSessionExceed())) {
                config.debug("已经初始化");
                return;
            }
            halt();
            ActivityServicesUtils as = new ActivityServicesUtils(context);
            String processName = as.getMyProcessName();
            config.setSharedPreferencesName(appKey + processName);
            config.setAppkey(appKey);
            config.setChannel(channel);
            if (config.getAppkey().equals("null") || config.getChannel().equals("null")) {
                config.debug("没有填写Appkey或者渠道名");
                return;
            }
            /**
             * 初始化设备信息
             */
            config.initDeviceInfo(context);
            if (config.getDid() == null)
                return;
            /**
             * 初始化应用信息
             */
            config.initAppinfo(context);
            config.debug("初始化成功\n" + config.getInitDebugInfo(context));

            if (config.getDid() == null)
                return;
            // 会话在30s内就不发送session start
            if (preSessionEnd != -1 && ((System.currentTimeMillis() - preSessionEnd) / 1000 < config.getSessionExceed())) {
                config.debug("30s内启动");
                return;
            } else {
                config.debug("会话开始");
                config.initEvent(context);
            }
            updateSessionEnd();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void flush(Context context) {
        try {
            if (config.getDid() == null)
                return;
            updateSessionEnd();
            config.completeLastSession(context, 2);
            config.sendData();
            config.stopUpload();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void updateSessionEnd() {
        preSessionEnd = System.currentTimeMillis();
        config.saveSessionEnd(preSessionEnd);
    }

    public synchronized void setDebug(boolean debug) {
        config.setDebug(debug);
    }

    public synchronized void disableAccounts(boolean accounts) {
        config.setDisableAccounts(accounts);
    }

    public synchronized void disablePhoneNumber(boolean phone) {
        config.setDisablePhonenum(phone);
    }

    public synchronized void onEvent(Context context, String event_name, JSONObject kv) {
        if (config.getDid() == null)
            return;
        config.onCustomEvent(context, event_name, kv);
    }

    public synchronized void onEvent(Context context, String event_name, HashMap<String, Object> kv) {
        if (config.getDid() == null)
            return;
        config.onCustomEvent(context, event_name, kv);
    }

    public synchronized void onEvent(Context context, String event_name) {
        if (config.getDid() == null)
            return;
        config.onCustomEvent(context, event_name);
    }

    public synchronized void identify(Context context, String uid, HashMap<String, Object> kv) {
        if (config.getDid() == null)
            return;
        config.identifyPerson(context, uid, kv);
    }

    public synchronized void identify(Context context, String uid, JSONObject kv) {
        if (config.getDid() == null)
            return;
        config.identifyPerson(context, uid, kv);
    }

    /**
     * channel 参数使用ZhugeSDK.PushChannel获得
     *
     * @param channel
     *            要关联的第三方渠道名称，PushChannle枚举类中的一种
     * @param userId
     *            客户端ID
     */
    public void setThirdPartyPushUserId(PushChannel channel, String userId) {
        if (null == channel || null == userId) {
            return;
        }
        String chan = channel.toString();
        config.channelData(chan, userId);
    }

    public void onMsgReaded(PushChannel channel, Object t) {
        config.parseMid(config.MSG_READ, channel, t);
    }

    public void onMsgRecved(PushChannel channel, Object t) {
        config.parseMid(config.MSG_RECV, channel, t);
    }
}
