package com.zhuge.analysis.sys_svs;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.List;

/**
 * Created by kongmiao on 14-4-15.
 * 包信息相关工具类
 */
public class PackageInfosUtils {

    private PackageManager packageManager;
    public PackageInfosUtils(Context context){
        this.packageManager = context.getPackageManager();
    }

    /**
     * 获取用户安装的应用列表
     * @return
     */
    public JSONArray getUserAppInfos(){
    	JSONArray appInfos = new JSONArray();
        List<PackageInfo> packageInfos = this.packageManager.getInstalledPackages(PackageManager.GET_UNINSTALLED_PACKAGES);
        for(PackageInfo pinfo: packageInfos)
        {
            try{
                ApplicationInfo applicationInfo = pinfo.applicationInfo;
                if(filterApp(applicationInfo)){
                    JSONObject tmpAppInfo = new JSONObject();
                    tmpAppInfo.put("an", applicationInfo.loadLabel(this.packageManager).toString());
                    tmpAppInfo.put("pn", pinfo.packageName);
                    tmpAppInfo.put("vn", pinfo.versionName);
                    appInfos.put(tmpAppInfo);
                }
            }catch (Exception e){
                e.printStackTrace();
            }

        }
        return appInfos;
    }

    /**
     * 过滤系统应用
     * @param info
     * @return
     */
    public boolean filterApp(ApplicationInfo info) {
        if ((info.flags & ApplicationInfo.FLAG_UPDATED_SYSTEM_APP) != 0) {
            // 代表的是系统的应用,但是被用户升级了. 用户应用
            return true;
        } else if ((info.flags & ApplicationInfo.FLAG_SYSTEM) == 0) {
            // 代表的用户的应用
            return true;
        }
        return false;
    }

}
