package com.zhuge.analysis.sys_svs;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import com.zhuge.analysis.stat.ZhugeSDK;

/**
 * Manifest操作类
 * Created by kongmiao on 14-10-11.
 */
public class ManifestUtils {

	/**
	 * 获取包信息
	 * @param context
	 * @return
	 */
    public static PackageInfo getAppInfo(Context context){
        PackageInfo appInfo = null;
        try {
            appInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }catch (PackageManager.NameNotFoundException e){
            ZhugeSDK.getInstance().getConfig().debug("获取应用名称失败");
        }
        return  appInfo;
    }

    /**
     * 获取开发者配置信息
     * @param context 应用上下文
     * @return AppKey 与Channel信息组成的字符串，若出错或未填写返回空字符串
     */
    public static String[] getDevInfo(Context context){
        String[] devInfo;
        String ak;
        String cn;
        ApplicationInfo appInfo;
        try {
            appInfo = context.getPackageManager()
                    .getApplicationInfo(context.getPackageName(),
                            PackageManager.GET_META_DATA);
        } catch (PackageManager.NameNotFoundException e) {
            ZhugeSDK.getInstance().getConfig().debug("获取应用名称失败");
            return new String[]{"null", "null"};
        }
        ak = appInfo.metaData.get("ZHUGE_APPKEY")+"";
        cn = appInfo.metaData.get("ZHUGE_CHANNEL")+"";
        devInfo = new String[]{ak, cn};
        return  devInfo;
    }
}
