package com.zhuge.analysis.sys_svs;

import android.app.ActivityManager;
import android.content.Context;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.List;

/**
 * Acitivity管理类
 * Created by kongmiao on 14-10-13.
 */
public class ActivityServicesUtils {
    private ActivityManager activityManager;

    public ActivityServicesUtils(Context context){
        activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
    }

    /**
     * 获取最近的任务列表
     * @return
     */
    public JSONArray getRecentTasks(){
    	JSONArray tasks = new JSONArray();
        try{
            List<ActivityManager.RunningAppProcessInfo> tasksInfo = activityManager.getRunningAppProcesses();
            int count = 0;
            for(ActivityManager.RunningAppProcessInfo task: tasksInfo){
                try{
                    if(task.pkgList.length == 0)
                        continue;
                    if(task.processName.contains("com.android") || task.processName.equals("system"))
                        continue;
                    JSONObject taskObject = new JSONObject();
                    taskObject.put("pn", task.processName);
                    taskObject.put("top", count);
                    tasks.put(taskObject);
                    count++;
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
        }catch(Exception e){
            e.printStackTrace();
        }
        return tasks;

    }
    
    /**
     * 获取当前的任务列表
     * @return
     */
    public String getForegroundPackageOld(){
        try{
            List<ActivityManager.RunningTaskInfo> tasksInfo = activityManager.getRunningTasks(1);
            for(ActivityManager.RunningTaskInfo task: tasksInfo){
                try{
                   return task.topActivity.getPackageName();
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
        }catch(Exception e){
            e.printStackTrace();
        }
        return null;

    }

    /**
     * 获取当前的任务列表
     * @return
     */
    public String getForegroundPackage(){
        try{
            List<ActivityManager.RunningAppProcessInfo> tasksInfo = activityManager.getRunningAppProcesses();
            for(ActivityManager.RunningAppProcessInfo task: tasksInfo){
                try{
                    return task.processName;
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
        }catch(Exception e){
            e.printStackTrace();
        }
        return null;

    }
}
