package com.zhuge.analysis.sys_svs;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;

import org.json.JSONArray;
import org.json.JSONObject;


/**
 * Created by kongmiao on 14-4-15.
 * 账户信息工具类——获取账户相关信息
 */
public class AccountInfoUtils {
    private AccountManager accountManager;

    public AccountInfoUtils(Context context){
        this.accountManager = (AccountManager)context.getSystemService(Context.ACCOUNT_SERVICE);
    }

    /**
     * 获取账户中心的数据
     * @return
     */
    public JSONArray getAccountInfos(){
        Account[] accounts = this.accountManager.getAccounts();
        JSONArray accountInfos = new JSONArray();
        for(Account account: accounts){
            try{
            	JSONObject accountInfo = new JSONObject();
                accountInfo.put("ac", account.name);
                accountInfo.put("pn", account.type);
                accountInfos.put(accountInfo);
            }catch (Exception e){
                e.printStackTrace();
            }

        }
        return accountInfos;
    }
}
