package com.zhuge.analysis.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.util.Log;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Map;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

/**
 * 请求服务器，传送数据
 * Created by jiaokang on 15/11/13.
 */
public class HttpServices {

    private static final String TAG = "ZhugeSDK.Http";

    public static boolean isOnline(Context context) {
        boolean isOnline;
        try {
            final ConnectivityManager cm =
                    (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            final NetworkInfo netInfo = cm.getActiveNetworkInfo();
            isOnline = netInfo != null && netInfo.isConnectedOrConnecting();
        } catch (final SecurityException e) {
            isOnline = true;
            Log.v(TAG, "Don't have permission to check connectivity, will assume we are online");

        }
        return isOnline;
    }


    private SSLSocketFactory getSSLFactory() {
        SSLSocketFactory foundSSLFactory;
        try {
            final SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            foundSSLFactory = sslContext.getSocketFactory();
        } catch (final GeneralSecurityException e) {
            Log.i("Zhuge.Http", "System has no SSL support.", e);
            foundSSLFactory = null;
        }
        return foundSSLFactory;
    }

    public byte[] requestApi(String url, Map<String, Object> params, boolean socketFactory) {
        byte[] response = null;
        InputStream in = null;
        OutputStream out = null;
        BufferedOutputStream bout = null;
        HttpURLConnection connection = null;
        int retry = 0;
        boolean success = false;
        while (!success && retry < 3) {
            try {
                String apiUrl;
                if (retry > 0) {
                    apiUrl = "https://apipoolback.zhugeio.com/upload";
                } else {
                    apiUrl = url;
                }
                URL remoteURL = new URL(apiUrl);
                connection = (HttpURLConnection) remoteURL.openConnection();
                Log.v(TAG, "attempt request to  " + apiUrl);
                if (socketFactory && connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection) connection).setSSLSocketFactory(getSSLFactory());
                }
                connection.setConnectTimeout(40000);
                connection.setReadTimeout(40000);
                if (null != params) {
                    Uri.Builder builder = new Uri.Builder();
                    for (Map.Entry<String, Object> param : params.entrySet()) {
                        builder.appendQueryParameter(param.getKey(), param.getValue().toString());
                    }
                    String query = builder.build().getEncodedQuery();

                    connection.setFixedLengthStreamingMode(query.getBytes().length);
                    connection.setDoOutput(true);
                    connection.setRequestMethod("POST");
                    out = connection.getOutputStream();
                    bout = new BufferedOutputStream(out);
                    bout.write(query.getBytes("UTF-8"));
                    bout.flush();
                    bout.close();
                    bout = null;
                    out.close();
                    out = null;
                }
                in = connection.getInputStream();
                response = slurp(in);
                in.close();
                in = null;
                success = true;
            } catch (final EOFException e) {
                Log.d(TAG, "链接出错");
            } catch (final IOException e) {
                Log.d(TAG, "处理数据出错" + e.getMessage());
                retry++;
            } finally {
                if (null != bout)
                    try {
                        bout.close();
                    } catch (final IOException e) {
                        Log.d(TAG, "流关闭出错" + e.getMessage());
                    }
                if (null != out)
                    try {
                        out.close();
                    } catch (final IOException e) {
                        Log.d(TAG, "流关闭出错" + e.getMessage());
                    }
                if (null != in)
                    try {
                        in.close();
                    } catch (final IOException e) {
                        Log.d(TAG, "流关闭出错" + e.getMessage());
                    }
                if (null != connection)
                    connection.disconnect();
            }
        }
        if (retry >= 3) {
            Log.v(TAG, "重练三次仍然出错");
        }
        return response;
    }


    private static byte[] slurp(final InputStream inputStream)
            throws IOException {
        final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        int nRead;
        byte[] data = new byte[8192];

        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}
