package com.zhuge.analysis.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.TimeZone;

/**
 * 其他工具类
 * Created by jiaokang on 15/11/9.
 */
public class Utils {
    /**
     * md5加密
     *
     * @param string 待加密字符
     * @return 加密字符
     */
    public static String md5(String string) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Huh, MD5 should be supported?", e);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Huh, UTF-8 should be supported?", e);
        }

        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 0x10)
                hex.append("0");
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static String formatTime(long time) {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setGroupingUsed(false);
        return nf.format(time / 1000.0);
    }

    public static int getTimeZone() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getOffset(System.currentTimeMillis());
    }
}
