/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class PackageInfosUtils {
    private PackageManager packageManager;

    public PackageInfosUtils(Context context) {
        this.packageManager = context.getPackageManager();
    }

    public JSONArray getUserAppInfos() {
        JSONArray appInfos = new JSONArray();
        List packageInfos = this.packageManager.getInstalledPackages(8192);
        for (PackageInfo pinfo : packageInfos) {
            try {
                ApplicationInfo applicationInfo = pinfo.applicationInfo;
                if (!this.filterApp(applicationInfo)) continue;
                JSONObject tmpAppInfo = new JSONObject();
                tmpAppInfo.put("an", (Object)applicationInfo.loadLabel(this.packageManager).toString());
                tmpAppInfo.put("pn", (Object)pinfo.packageName);
                tmpAppInfo.put("vn", (Object)pinfo.versionName);
                appInfos.put((Object)tmpAppInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return appInfos;
    }

    public boolean filterApp(ApplicationInfo info) {
        if ((info.flags & 0x80) != 0) {
            return true;
        }
        return (info.flags & 1) == 0;
    }
}

