/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.stat;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.zhuge.analysis.stat.CodeLessConfig;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONObject;

class ZhugeDbAdapter {
    private static final String LOGTAG = "Zhuge.Database";
    private static final String TABLE_NAME = "events";
    public static final String KEY_DATA = "data";
    public static final String KEY_CREATED_AT = "created_at";
    private static final String DATABASE_NAME = "zhuge";
    private static final int DATABASE_VERSION = 1;
    private static final String CREATE_EVENTS_TABLE = "CREATE TABLE events (_id INTEGER PRIMARY KEY AUTOINCREMENT, data TEXT NOT NULL, created_at INTEGER NOT NULL);";
    private static final String EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON events (created_at);";
    private final ZhugeDbHelper mDbHelper;

    ZhugeDbAdapter(Context context) {
        this.mDbHelper = new ZhugeDbHelper(context, DATABASE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addEvent(JSONObject jsonObject) {
        Cursor cursor = null;
        int count = -1;
        try {
            SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put(KEY_DATA, jsonObject.toString());
            contentValues.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
            db.insert(TABLE_NAME, null, contentValues);
            cursor = db.rawQuery("SELECT COUNT(*) FROM events", null);
            cursor.moveToFirst();
            count = cursor.getInt(0);
        }
        catch (Exception e) {
            Log.e((String)LOGTAG, (String)("Zhuge \u5411\u6570\u636e\u5e93\u63d2\u5165\u6570\u636e\u51fa\u9519" + e.getMessage()));
            this.mDbHelper.deleteDatabase();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.mDbHelper.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getData() {
        Cursor cursor = null;
        String data = null;
        String last_id = null;
        int size = 0;
        try {
            SQLiteDatabase db = this.mDbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT * FROM events ORDER BY created_at ASC LIMIT 50", null);
            JSONArray array = new JSONArray();
            while (cursor.moveToNext()) {
                if (cursor.isLast()) {
                    last_id = cursor.getString(cursor.getColumnIndex("_id"));
                }
                String s = cursor.getString(cursor.getColumnIndex(KEY_DATA));
                JSONObject jsonObject = new JSONObject(s);
                array.put((Object)jsonObject);
                ++size;
            }
            if (array.length() > 0) {
                data = array.toString();
            }
        }
        catch (Exception e) {
            Log.e((String)LOGTAG, (String)"Could not pull records for Zhuge out of database events. Waiting to send.", (Throwable)e);
            last_id = null;
            data = null;
        }
        finally {
            this.mDbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
        }
        if (data != null && last_id != null) {
            return new String[]{last_id, data, size + ""};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEvent(String lastID) {
        try {
            SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
            db.delete(TABLE_NAME, "_id <= " + lastID, null);
        }
        catch (SQLiteException e) {
            Log.e((String)LOGTAG, (String)"Could not clean sent Zhuge records from events. Re-initializing database.", (Throwable)e);
            this.mDbHelper.deleteDatabase();
        }
        finally {
            this.mDbHelper.close();
        }
    }

    private static class ZhugeDbHelper
    extends SQLiteOpenHelper {
        private final CodeLessConfig mConfig;
        private final File mFile;

        public ZhugeDbHelper(Context context, String name) {
            super(context, name, null, 1);
            this.mConfig = CodeLessConfig.getInstance(context);
            this.mFile = context.getDatabasePath(ZhugeDbAdapter.DATABASE_NAME);
        }

        public void onCreate(SQLiteDatabase db) {
            this.mConfig.debug("\u521b\u5efa\u65b0\u7684Zhuge database\u3002");
            db.execSQL(ZhugeDbAdapter.CREATE_EVENTS_TABLE);
            db.execSQL(ZhugeDbAdapter.EVENTS_TIME_INDEX);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.mConfig.debug("\u66f4\u65b0Zhuge database");
            db.execSQL("DROP TABLE IF EXISTS events");
            db.execSQL(ZhugeDbAdapter.CREATE_EVENTS_TABLE);
            db.execSQL(ZhugeDbAdapter.EVENTS_TIME_INDEX);
        }

        void deleteDatabase() {
            this.close();
            this.mFile.delete();
        }
    }
}

