/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.viewSpider;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import com.zhuge.analysis.viewSpider.UIThreadSet;
import com.zhuge.analysis.viewSpider.ViewVisitor;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EditState
extends UIThreadSet<Activity> {
    private final Handler mUiThreadHandler = new Handler(Looper.getMainLooper());
    private final Map<String, List<ViewVisitor>> mIntendedEdits = new HashMap<String, List<ViewVisitor>>();
    private final Set<EditBinding> mCurrentEdits = new HashSet<EditBinding>();

    @Override
    public void add(Activity newOne) {
        super.add(newOne);
        this.applyEditsOnUiThread();
    }

    @Override
    public void remove(Activity oldOne) {
        super.remove(oldOne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEdits(Map<String, List<ViewVisitor>> newEdits) {
        Object object = this.mCurrentEdits;
        synchronized (object) {
            for (EditBinding stale : this.mCurrentEdits) {
                stale.kill();
            }
            this.mCurrentEdits.clear();
        }
        object = this.mIntendedEdits;
        synchronized (object) {
            this.mIntendedEdits.clear();
            this.mIntendedEdits.putAll(newEdits);
        }
        this.applyEditsOnUiThread();
    }

    private void applyEditsOnUiThread() {
        if (Thread.currentThread() == this.mUiThreadHandler.getLooper().getThread()) {
            this.applyIntendedEdits();
        } else {
            this.mUiThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    EditState.this.applyIntendedEdits();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyIntendedEdits() {
        for (Activity activity : this.getAll()) {
            List<ViewVisitor> wildcardChanges;
            List<ViewVisitor> specificChanges;
            String activityName = activity.getClass().getCanonicalName();
            View rootView = activity.getWindow().getDecorView().getRootView();
            Map<String, List<ViewVisitor>> map = this.mIntendedEdits;
            synchronized (map) {
                specificChanges = this.mIntendedEdits.get(activityName);
                wildcardChanges = this.mIntendedEdits.get(null);
            }
            if (null != specificChanges) {
                this.applyChangesFromList(rootView, specificChanges);
            }
            if (null == wildcardChanges) continue;
            this.applyChangesFromList(rootView, wildcardChanges);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChangesFromList(View rootView, List<ViewVisitor> changes) {
        Set<EditBinding> set = this.mCurrentEdits;
        synchronized (set) {
            int size = changes.size();
            for (int i = 0; i < size; ++i) {
                ViewVisitor visitor = changes.get(i);
                EditBinding binding = new EditBinding(rootView, visitor, this.mUiThreadHandler);
                this.mCurrentEdits.add(binding);
            }
        }
    }

    private static class EditBinding
    implements ViewTreeObserver.OnGlobalLayoutListener,
    Runnable {
        private volatile boolean mDying;
        private boolean mAlive;
        private final WeakReference<View> mViewRoot;
        private final ViewVisitor mEdit;
        private final Handler mHandler;

        public EditBinding(View viewRoot, ViewVisitor edit, Handler uiThreadHandler) {
            this.mEdit = edit;
            this.mViewRoot = new WeakReference<View>(viewRoot);
            this.mHandler = uiThreadHandler;
            this.mAlive = true;
            this.mDying = false;
            ViewTreeObserver observer = viewRoot.getViewTreeObserver();
            if (observer.isAlive()) {
                observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            this.run();
        }

        public void onGlobalLayout() {
            this.run();
        }

        @Override
        public void run() {
            if (!this.mAlive) {
                return;
            }
            View viewRoot = (View)this.mViewRoot.get();
            if (null == viewRoot || this.mDying) {
                this.cleanUp();
                return;
            }
            this.mEdit.visit(viewRoot);
            this.mHandler.removeCallbacks((Runnable)this);
            this.mHandler.postDelayed((Runnable)this, 1000L);
        }

        public void kill() {
            this.mDying = true;
            this.mHandler.post((Runnable)this);
        }

        private void cleanUp() {
            if (this.mAlive) {
                ViewTreeObserver observer;
                View viewRoot = (View)this.mViewRoot.get();
                if (null != viewRoot && (observer = viewRoot.getViewTreeObserver()).isAlive()) {
                    observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.mEdit.cleanup();
            }
            this.mAlive = false;
        }
    }
}

