/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class HttpServices {
    private static final String TAG = "ZhugeSDK.Http";

    public static boolean isOnline(Context context) {
        boolean isOnline;
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            isOnline = netInfo != null && netInfo.isConnectedOrConnecting();
        }
        catch (SecurityException e) {
            isOnline = true;
            Log.v((String)TAG, (String)"Don't have permission to check connectivity, will assume we are online");
        }
        return isOnline;
    }

    private SSLSocketFactory getSSLFactory() {
        SSLSocketFactory foundSSLFactory;
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            foundSSLFactory = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            Log.i((String)"Zhuge.Http", (String)"System has no SSL support.", (Throwable)e);
            foundSSLFactory = null;
        }
        return foundSSLFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] requestApi(String url, Map<String, Object> params, boolean socketFactory) {
        byte[] response = null;
        InputStream in = null;
        OutputStream out = null;
        FilterOutputStream bout = null;
        HttpURLConnection connection = null;
        int retry = 0;
        boolean success = false;
        while (!success && retry < 3) {
            try {
                String apiUrl = retry > 0 ? "https://apipoolback.zhugeio.com/upload" : url;
                URL remoteURL = new URL(apiUrl);
                connection = (HttpURLConnection)remoteURL.openConnection();
                Log.v((String)TAG, (String)("attempt request to  " + apiUrl));
                if (socketFactory && connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(this.getSSLFactory());
                }
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
                if (null != params) {
                    Uri.Builder builder = new Uri.Builder();
                    for (Map.Entry<String, Object> param : params.entrySet()) {
                        builder.appendQueryParameter(param.getKey(), param.getValue().toString());
                    }
                    String query = builder.build().getEncodedQuery();
                    connection.setFixedLengthStreamingMode(query.getBytes().length);
                    connection.setDoOutput(true);
                    connection.setRequestMethod("POST");
                    out = connection.getOutputStream();
                    bout = new BufferedOutputStream(out);
                    bout.write(query.getBytes("UTF-8"));
                    ((BufferedOutputStream)bout).flush();
                    bout.close();
                    bout = null;
                    out.close();
                    out = null;
                }
                in = connection.getInputStream();
                response = HttpServices.slurp(in);
                in.close();
                in = null;
                success = true;
            }
            catch (EOFException e) {
                Log.d((String)TAG, (String)"\u94fe\u63a5\u51fa\u9519");
            }
            catch (IOException e) {
                Log.d((String)TAG, (String)("\u5904\u7406\u6570\u636e\u51fa\u9519" + e.getMessage()));
                ++retry;
            }
            finally {
                if (null != bout) {
                    try {
                        bout.close();
                    }
                    catch (IOException e) {
                        Log.d((String)TAG, (String)("\u6d41\u5173\u95ed\u51fa\u9519" + e.getMessage()));
                    }
                }
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        Log.d((String)TAG, (String)("\u6d41\u5173\u95ed\u51fa\u9519" + e.getMessage()));
                    }
                }
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        Log.d((String)TAG, (String)("\u6d41\u5173\u95ed\u51fa\u9519" + e.getMessage()));
                    }
                }
                if (null == connection) continue;
                connection.disconnect();
            }
        }
        if (retry >= 3) {
            Log.v((String)TAG, (String)"\u91cd\u7ec3\u4e09\u6b21\u4ecd\u7136\u51fa\u9519");
        }
        return response;
    }

    private static byte[] slurp(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

