/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ActivityServicesUtils {
    private ActivityManager activityManager;

    public ActivityServicesUtils(Context context) {
        this.activityManager = (ActivityManager)context.getSystemService("activity");
    }

    public JSONArray getRecentTasks() {
        JSONArray tasks = new JSONArray();
        try {
            List tasksInfo = this.activityManager.getRunningAppProcesses();
            int count = 0;
            for (ActivityManager.RunningAppProcessInfo task : tasksInfo) {
                try {
                    if (task.pkgList.length == 0 || task.processName.contains("com.android") || task.processName.equals("system")) continue;
                    JSONObject taskObject = new JSONObject();
                    taskObject.put("pn", (Object)task.processName);
                    taskObject.put("top", count);
                    tasks.put((Object)taskObject);
                    ++count;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tasks;
    }

    public String getMyProcessName() {
        int pid = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo processInfo : this.activityManager.getRunningAppProcesses()) {
            if (processInfo.pid != pid) continue;
            return processInfo.processName;
        }
        return "";
    }

    public String getForegroundPackage() {
        try {
            List tasksInfo = this.activityManager.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo task : tasksInfo) {
                try {
                    return task.processName;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

