/*
 * Decompiled with CFR 0.152.
 */
package com.zhokhov.graphql.datetime.boot;

import com.zhokhov.graphql.datetime.DateScalar;
import com.zhokhov.graphql.datetime.DurationScalar;
import com.zhokhov.graphql.datetime.LocalDateScalar;
import com.zhokhov.graphql.datetime.LocalDateTimeScalar;
import com.zhokhov.graphql.datetime.LocalTimeScalar;
import com.zhokhov.graphql.datetime.OffsetDateTimeScalar;
import com.zhokhov.graphql.datetime.YearMonthScalar;
import com.zhokhov.graphql.datetime.boot.GraphQLDateTimeProperties;
import graphql.kickstart.autoconfigure.tools.GraphQLJavaToolsAutoConfiguration;
import graphql.schema.GraphQLScalarType;
import java.time.format.DateTimeFormatter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={GraphQLJavaToolsAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLDateTimeProperties.class})
public class GraphQLDateTimeAutoConfiguration {
    @Bean(name={"graphQLDate"})
    @ConditionalOnMissingBean(name={"graphQLDate"})
    public GraphQLScalarType graphQLDate(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getDate().getScalarName();
        return DateScalar.create((String)name);
    }

    @Bean(name={"graphQLLocalDate"})
    @ConditionalOnMissingBean(name={"graphQLLocalDate"})
    public GraphQLScalarType graphQLLocalDate(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getLocalDate().getScalarName();
        String format = configurationProperties.getLocalDate().getFormat();
        return LocalDateScalar.create((String)name, (boolean)configurationProperties.isZoneConversionEnabled(), (DateTimeFormatter)(format != null ? DateTimeFormatter.ofPattern(format) : null));
    }

    @Bean(name={"graphQLLocalDateTime"})
    @ConditionalOnMissingBean(name={"graphQLLocalDateTime"})
    public GraphQLScalarType graphQLLocalDateTime(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getLocalDateTime().getScalarName();
        String format = configurationProperties.getLocalDateTime().getFormat();
        return LocalDateTimeScalar.create((String)name, (boolean)configurationProperties.isZoneConversionEnabled(), (DateTimeFormatter)(format != null ? DateTimeFormatter.ofPattern(format) : null));
    }

    @Bean(name={"graphQLLocalTime"})
    @ConditionalOnMissingBean(name={"graphQLLocalTime"})
    public GraphQLScalarType graphQLLocalTime(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getLocalTime().getScalarName();
        return LocalTimeScalar.create((String)name);
    }

    @Bean(name={"graphQLOffsetDateTime"})
    @ConditionalOnMissingBean(name={"graphQLOffsetDateTime"})
    public GraphQLScalarType graphQLOffsetDateTime(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getOffsetDateTime().getScalarName();
        return OffsetDateTimeScalar.create((String)name);
    }

    @Bean(name={"graphQLYearMonth"})
    @ConditionalOnMissingBean(name={"graphQLYearMonth"})
    public GraphQLScalarType graphQLYearMonth(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getYearMonth().getScalarName();
        return YearMonthScalar.create((String)name);
    }

    @Bean(name={"graphQLDuration"})
    @ConditionalOnMissingBean(name={"graphQLDuration"})
    public GraphQLScalarType graphQLDuration(GraphQLDateTimeProperties configurationProperties) {
        String name = configurationProperties.getDuration().getScalarName();
        return DurationScalar.create((String)name);
    }
}

