package com.zerodeplibs.webpush.ext.jwt.nimbusjose;

import com.zerodeplibs.webpush.jwt.VAPIDJWTGenerator;
import com.zerodeplibs.webpush.jwt.VAPIDJWTGeneratorFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

/**
 * The factory class for {@link VAPIDJWTGenerator}.
 * {@link VAPIDJWTGenerator}s generated by this class utilizes <a href="https://connect2id.com/products/nimbus-jose-jwt">Nimbus JOSE + JWT</a>.
 *
 * @author Tomoki Sato
 */
public class NimbusJoseVAPIDJWTGeneratorFactory implements VAPIDJWTGeneratorFactory {

    @Override
    public VAPIDJWTGenerator create(ECPrivateKey privateKey,
                                    ECPublicKey publicKey) {
        return new NimbusJoseVAPIDJWTGenerator(privateKey);
    }
}
