/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.recyclerView;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.zengcanxiang.baseAdapter.interFace.DataHelper;
import com.zengcanxiang.baseAdapter.recyclerView.BaseAdapter;
import com.zengcanxiang.baseAdapter.recyclerView.BaseViewHolder;
import com.zengcanxiang.baseAdapter.recyclerView.HelperViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class HelperAdapter<T>
extends BaseAdapter<T>
implements DataHelper<T> {
    public HelperAdapter(List<T> data, Context context, int ... layoutId) {
        super(data, context, layoutId);
    }

    @Override
    public final HelperViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType < 0 || viewType > this.mLayoutId.length) {
            throw new ArrayIndexOutOfBoundsException("checkLayoutIndex > LayoutId.length \uff1a" + viewType + ">" + this.mLayoutId.length);
        }
        if (this.mLayoutId.length == 0) {
            throw new IllegalArgumentException("not layoutId");
        }
        this.mParent = parent;
        int layoutId = this.mLayoutId[viewType];
        View view = this.inflaterView(layoutId);
        HelperViewHolder viewHolder = (HelperViewHolder)view.getTag();
        if (viewHolder == null || viewHolder.getLayoutId() != layoutId) {
            viewHolder = new HelperViewHolder(this.mContext, layoutId, view);
        }
        if (this.mOnItemClickListener != null) {
            final HelperViewHolder finalViewHolder = viewHolder;
            viewHolder.getItemView().setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int position = finalViewHolder.getAdapterPosition();
                    HelperAdapter.this.mOnItemClickListener.onItemClick(finalViewHolder, position -= HelperAdapter.this.getHeadSize(), HelperAdapter.this.mList.get(position));
                }
            });
        }
        return viewHolder;
    }

    @Override
    protected final void bindData(BaseViewHolder viewHolder, int position, T item) {
        HelperViewHolder helperViewHolder = (HelperViewHolder)viewHolder;
        this.HelperBindData(helperViewHolder, position, item);
    }

    @Override
    protected final void bindData(BaseViewHolder viewHolder, int position, T item, List<Object> payloads) {
        HelperViewHolder helperViewHolder = (HelperViewHolder)viewHolder;
        this.HelperBindData(helperViewHolder, position, item, payloads);
    }

    protected void HelperBindData(HelperViewHolder viewHolder, int position, T item, List<Object> payloads) {
    }

    protected abstract void HelperBindData(HelperViewHolder var1, int var2, T var3);

    @Override
    public boolean isEnabled() {
        if (this.mList == null) {
            return false;
        }
        return this.mList.size() > 0;
    }

    @Override
    public void addItemToHead(T data) {
        this.add(0, data);
    }

    @Override
    public boolean addItemToLast(T data) {
        if (!this.isEnabled()) {
            this.addItemToHead(data);
            return true;
        }
        boolean result = this.mList.add(data);
        this.notifyItemInserted(this.mList.size() - 1);
        return result;
    }

    @Override
    public boolean addItemsToHead(List<T> datas) {
        return this.addAll(0, datas);
    }

    @Override
    public boolean addItemsToLast(List<T> datas) {
        if (!this.isEnabled()) {
            this.addItemsToHead(datas);
        }
        return this.addAll(this.mList.size() - 1, datas);
    }

    @Override
    public boolean addAll(int startPosition, List<T> datas) {
        this.initList();
        boolean result = this.mList.addAll(startPosition < 0 ? 0 : startPosition, datas);
        this.notifyItemRangeInserted(startPosition, datas.size());
        return result;
    }

    @Override
    public void add(int startPosition, T data) {
        this.initList();
        this.mList.add(startPosition, data);
        this.notifyItemInserted(startPosition);
    }

    @Override
    public T getData(int position) {
        return this.getItemCount() == 0 ? null : (T)this.mList.get(position);
    }

    @Override
    public void alterObj(T oldData, T newData) {
        this.alterObj(this.mList.indexOf(oldData), newData);
    }

    @Override
    public void alterObj(int position, T data) {
        this.initList();
        this.mList.set(position, data);
        this.notifyItemRangeChanged(position, 1);
    }

    @Override
    public boolean remove(T data) {
        if (this.mList == null) {
            throw new IllegalArgumentException("list is null,cannot execute");
        }
        int position = this.mList.indexOf(data);
        boolean result = this.mList.remove(data);
        this.notifyItemRemoved(position);
        return result;
    }

    @Override
    public void removeToIndex(int position) {
        if (this.mList == null) {
            throw new IllegalArgumentException("list is null,cannot execute");
        }
        this.mList.remove(position);
        this.notifyItemRemoved(position);
    }

    @Override
    public void replaceAll(List<T> data) {
        this.initList();
        this.mList.clear();
        this.addAll(0, data);
    }

    @Override
    public void clear() {
        this.initList();
        this.mList.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(T data) {
        this.initList();
        return this.mList.contains(data);
    }

    private void initList() {
        if (this.mList == null) {
            this.mList = new ArrayList();
        }
    }

    @Override
    public final int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    @Override
    public int getItemCount() {
        return super.getItemCount();
    }
}

