/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.viewpager;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAdapter
extends PagerAdapter {
    private List<View> mViews;
    private Context mContext;

    public BaseAdapter(Context context, @NonNull List<View> views) {
        this.mContext = context;
        this.mViews = views;
    }

    public BaseAdapter(@NonNull List<Integer> viewIds, Context context) {
        this.mContext = context;
        this.mViews = this.id2Views(viewIds);
    }

    public BaseAdapter(Context context, int ... viewIds) {
        this.mContext = context;
        this.mViews = this.id2Views(viewIds);
    }

    public final int getCount() {
        return this.mViews == null ? 0 : this.mViews.size();
    }

    public final boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView(this.mViews.get(position));
    }

    public final Object instantiateItem(ViewGroup container, int position) {
        container.addView(this.mViews.get(position));
        this.convert(this.mViews.get(position), position);
        return this.mViews.get(position);
    }

    private List<View> id2Views(int ... ids) {
        ArrayList<View> temp = new ArrayList<View>();
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        for (int id : ids) {
            View view = inflater.inflate(id, null);
            temp.add(view);
        }
        return temp;
    }

    private List<View> id2Views(@NonNull List<Integer> ids) {
        ArrayList<View> temp = new ArrayList<View>();
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        for (int i : ids) {
            View view = inflater.inflate(ids.get(i).intValue(), null);
            temp.add(view);
        }
        return temp;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public abstract void convert(View var1, int var2);
}

