/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.recyclerView;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zengcanxiang.baseAdapter.recyclerView.HeadFootViewHolder;
import com.zengcanxiang.baseAdapter.recyclerView.HelperViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class HeadFootAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final int BASE_ID = -1;
    private final int BASE_ITEM_TYPE_FOOTER = 2000000;
    private int poolCacheSize = 5;
    private RecyclerView.Adapter mDataAdapter;
    private LayoutInflater mLInflater;
    private ViewGroup mParent;
    private ArrayList<Integer> mHeadLayouts = new ArrayList();
    private SparseArray<View> mFootViews = new SparseArray();
    private RecyclerView.LayoutManager mLayoutManager;

    public HeadFootAdapter(RecyclerView.Adapter dataAdapter) {
        this.mDataAdapter = dataAdapter;
        RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                HeadFootAdapter.this.notifyDataSetChanged();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                HeadFootAdapter.this.notifyItemRangeChanged(HeadFootAdapter.this.data2HeadPosition(positionStart), itemCount);
            }

            public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
                HeadFootAdapter.this.notifyItemRangeChanged(HeadFootAdapter.this.data2HeadPosition(positionStart), itemCount, payload);
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                HeadFootAdapter.this.notifyItemRangeInserted(HeadFootAdapter.this.data2HeadPosition(positionStart), itemCount);
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                HeadFootAdapter.this.notifyItemRangeRemoved(HeadFootAdapter.this.data2HeadPosition(positionStart), itemCount);
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                HeadFootAdapter.this.notifyItemRangeChanged(HeadFootAdapter.this.data2HeadPosition(fromPosition), HeadFootAdapter.this.data2HeadPosition(toPosition) + itemCount);
            }
        };
        this.mDataAdapter.registerAdapterDataObserver(mDataObserver);
        this.setHasStableIds(this.mDataAdapter.hasStableIds());
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        if (!this.mHeadLayouts.isEmpty()) {
            for (int i = 0; i < this.mHeadLayouts.size(); ++i) {
                recyclerView.getRecycledViewPool().setMaxRecycledViews(this.mHeadLayouts.get(i).intValue(), this.poolCacheSize);
            }
        }
        this.mLayoutManager = recyclerView.getLayoutManager();
        this.initLayoutManager();
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        ViewGroup.LayoutParams lp;
        int position = holder.getLayoutPosition();
        if ((this.isHead(position) || this.isFoot(position)) && (lp = holder.itemView.getLayoutParams()) != null && lp instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            p.setFullSpan(true);
        }
        this.mDataAdapter.onViewAttachedToWindow(holder);
    }

    private void initLayoutManager() {
        if (this.mLayoutManager instanceof GridLayoutManager) {
            final GridLayoutManager gridLayoutManager = (GridLayoutManager)this.mLayoutManager;
            final GridLayoutManager.SpanSizeLookup spanSizeLookup = gridLayoutManager.getSpanSizeLookup();
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (HeadFootAdapter.this.isHead(position) || HeadFootAdapter.this.isFoot(position)) {
                        return gridLayoutManager.getSpanCount();
                    }
                    return spanSizeLookup.getSpanSize(HeadFootAdapter.this.head2DataPosition(position));
                }
            });
            gridLayoutManager.setSpanCount(gridLayoutManager.getSpanCount());
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.mParent = parent;
        this.mLInflater = LayoutInflater.from((Context)parent.getContext());
        if (this.mFootViews.get(viewType) != null) {
            View footView = (View)this.mFootViews.get(viewType);
            return HeadFootViewHolder.get(parent.getContext(), footView, parent, viewType);
        }
        if (!this.mHeadLayouts.isEmpty()) {
            for (int i = 0; i < this.mHeadLayouts.size(); ++i) {
                if (this.mHeadLayouts.get(i) != viewType) continue;
                return HeadFootViewHolder.get(parent.getContext(), null, parent, viewType);
            }
        }
        return this.mDataAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof HeadFootViewHolder) {
            if (this.isHead(position)) {
                this.disposeHeadView((HelperViewHolder)holder, position);
            } else if (this.isFoot(position)) {
                this.disposeFootView((HelperViewHolder)holder, position);
            }
        } else {
            this.mDataAdapter.onBindViewHolder(holder, this.head2DataPosition(position));
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        if (holder instanceof HeadFootViewHolder) {
            if (this.isHead(position)) {
                this.disposeHeadView((HeadFootViewHolder)holder, position);
            } else if (this.isFoot(position)) {
                this.disposeFootView((HeadFootViewHolder)holder, position);
            }
        } else {
            this.mDataAdapter.onBindViewHolder(holder, this.head2DataPosition(position), payloads);
        }
    }

    public int getItemCount() {
        int itemCount = this.mDataAdapter.getItemCount();
        if (this.hasHeadView()) {
            itemCount += this.getHeadSize();
        }
        if (this.hasFootView()) {
            itemCount += this.getFootSize();
        }
        return itemCount;
    }

    public long getItemId(int position) {
        if (this.isHead(position)) {
            return 0 + position;
        }
        if (this.isFoot(position)) {
            return -2 - position;
        }
        return this.mDataAdapter.getItemId(position);
    }

    public int getItemViewType(int position) {
        if (this.isHead(position)) {
            return this.mHeadLayouts.get(position);
        }
        if (this.isFoot(position)) {
            return this.mFootViews.keyAt(position - this.getHeadSize() - this.mDataAdapter.getItemCount());
        }
        return this.mDataAdapter.getItemViewType(this.head2DataPosition(position));
    }

    private boolean isHead(int position) {
        return this.hasHeadView() && this.getHeadSize() > position;
    }

    private boolean isFoot(int position) {
        return this.hasFootView() && position >= this.getHeadSize() + this.mDataAdapter.getItemCount();
    }

    public boolean hasHeadView() {
        return this.getHeadSize() != 0;
    }

    public boolean hasFootView() {
        return this.mFootViews.size() != 0;
    }

    public int getHeadSize() {
        return this.mHeadLayouts.size();
    }

    public int getFootSize() {
        return this.mFootViews.size();
    }

    public void addHeadView(@LayoutRes int layoutId) {
        this.mHeadLayouts.add(layoutId);
        this.notifyItemInserted(this.mHeadLayouts.size() - 1);
    }

    public void addHeadView(int index, @LayoutRes int layoutId) {
        if (index < 0) {
            index = 0;
        }
        index = index > this.mHeadLayouts.size() ? this.mHeadLayouts.size() : index;
        this.mHeadLayouts.add(index, layoutId);
        this.notifyItemInserted(index);
    }

    public void addFootView(View footView) {
        this.addFootView(this.mFootViews.size(), footView);
    }

    public void addFootView(int layoutId, View footView) {
        this.mFootViews.put(layoutId + 2000000, (Object)footView);
        this.notifyItemInserted(this.getItemCount() - 1);
    }

    public void addFootView(@LayoutRes int layoutId) {
        this.mFootViews.put(layoutId + 2000000, (Object)this.inflaterView(layoutId));
        this.notifyItemInserted(this.getItemCount() - 1);
    }

    public void removeHeadViewByIndex(int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.mHeadLayouts.size()) {
            index = this.mHeadLayouts.size() - 1;
        }
        this.mHeadLayouts.remove(index);
        this.notifyItemRemoved(index);
    }

    public void removeFootViewByIndex(int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.mFootViews.size()) {
            index = this.mFootViews.size() - 1;
        }
        this.mFootViews.removeAt(index);
        this.notifyItemRemoved(this.mHeadLayouts.size() + this.mDataAdapter.getItemCount() + index - 1);
    }

    public void removeHeadView(@LayoutRes int layoutId) {
        int index = this.mHeadLayouts.indexOf(layoutId);
        this.removeHeadViewByIndex(index);
    }

    public void removeFootView(@LayoutRes int layoutId) {
        int index = this.mFootViews.indexOfKey(2000000 + layoutId);
        if (index < 0) {
            throw new IllegalArgumentException("addFootView is the use of layoutId ? ");
        }
        this.removeFootViewByIndex(index);
    }

    public void removeFootView(View footView) {
        int i = this.mFootViews.indexOfValue((Object)footView);
        this.removeFootViewByIndex(i);
    }

    public void clearHeadView() {
        this.mHeadLayouts.clear();
        this.notifyDataSetChanged();
    }

    public void clearFootView() {
        this.mFootViews.clear();
        this.notifyDataSetChanged();
    }

    public View inflaterView(@LayoutRes int layoutId) {
        return this.mLInflater.inflate(layoutId, this.mParent, false);
    }

    private int head2DataPosition(int position) {
        return position - (this.hasHeadView() ? this.getHeadSize() : 0);
    }

    private int data2HeadPosition(int position) {
        return position + (this.hasHeadView() ? this.getHeadSize() : 0);
    }

    public abstract void disposeHeadView(HelperViewHolder var1, int var2);

    public abstract void disposeFootView(HelperViewHolder var1, int var2);
}

