/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.recyclerView;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zengcanxiang.baseAdapter.recyclerView.BH;
import com.zengcanxiang.baseAdapter.recyclerView.BaseViewHolder;
import java.util.List;

public abstract class BaseAdapter<T>
extends RecyclerView.Adapter<BH> {
    protected List<T> mList;
    protected Context mContext;
    protected LayoutInflater mLInflater;
    protected int[] mLayoutId;
    private SparseArray<View> mConvertViews = new SparseArray();

    public BaseAdapter(@NonNull List<T> data, Context context, int ... layoutId) {
        this.mList = data;
        this.mLayoutId = layoutId;
        this.mContext = context;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public final int getItemViewType(int position) {
        return this.checkLayoutIndex(this.mList.get(position), position);
    }

    public BH onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType < 0 || viewType > this.mLayoutId.length) {
            throw new ArrayIndexOutOfBoundsException("checkLayoutIndex > LayoutId.length \uff1a" + viewType + ">" + this.mLayoutId.length);
        }
        if (this.mLayoutId.length == 0) {
            throw new IllegalArgumentException("not layoutId");
        }
        int layoutId = this.mLayoutId[viewType];
        View view = this.inflateItemView(layoutId, parent);
        BaseViewHolder viewHolder = (BaseViewHolder)((Object)view.getTag());
        if (viewHolder == null || viewHolder.getLayoutId() != layoutId) {
            viewHolder = new BaseViewHolder(this.mContext, layoutId, view);
        }
        return viewHolder;
    }

    protected final View inflateItemView(int layoutId, ViewGroup viewGroup) {
        View convertView = (View)this.mConvertViews.get(layoutId);
        if (convertView == null) {
            convertView = this.mLInflater.inflate(layoutId, viewGroup, false);
        }
        return convertView;
    }

    public final void onBindViewHolder(BH holder, int position) {
        T item = this.mList.get(position);
        this.onBindData(holder, position, item);
    }

    public final int getItemCount() {
        return this.mList == null ? 0 : this.mList.size();
    }

    protected abstract void onBindData(BH var1, int var2, T var3);

    public int checkLayoutIndex(T item, int position) {
        return 0;
    }
}

