/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.absListView;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zengcanxiang.baseAdapter.absListView.BaseViewHolder;
import com.zengcanxiang.baseAdapter.absListView.HelperViewHolder;
import java.util.List;

public abstract class BaseAdapter<T>
extends android.widget.BaseAdapter {
    protected List<T> mList;
    protected Context mContext;
    protected LayoutInflater mLInflater;
    protected int[] layoutIds;
    private BaseViewHolder holder = new HelperViewHolder();

    public BaseAdapter(@NonNull List<T> data, Context context, int ... layoutIds) {
        this.mList = data;
        this.layoutIds = layoutIds;
        this.mContext = context;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public final View getView(int position, View convertView, ViewGroup parent) {
        int layoutId = this.getViewCheckLayoutId(position);
        this.holder = this.holder.get(this.mContext, position, convertView, parent, layoutId);
        this.convert(this.holder, position, this.mList.get(position));
        return this.holder.getConvertView(layoutId);
    }

    private int getViewCheckLayoutId(int position) {
        if (this.layoutIds == null || this.layoutIds.length == 0) {
            throw new IllegalArgumentException("not layoutId");
        }
        int layoutId = this.layoutIds[this.checkLayoutIndex(position, this.mList.get(position))];
        return layoutId;
    }

    public abstract <BH extends BaseViewHolder> void convert(BH var1, int var2, T var3);

    public int checkLayoutIndex(int position, T item) {
        return 0;
    }

    public final int getCount() {
        return this.mList == null ? 0 : this.mList.size();
    }

    public final Object getItem(int position) {
        return this.mList.get(position);
    }

    public final long getItemId(int position) {
        return position;
    }
}

