/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.recyclerView;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.zengcanxiang.baseAdapter.interFace.DataHelper;
import com.zengcanxiang.baseAdapter.recyclerView.BH;
import com.zengcanxiang.baseAdapter.recyclerView.BaseAdapter;
import com.zengcanxiang.baseAdapter.recyclerView.HelperViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class HelperAdapter<T>
extends BaseAdapter<T>
implements DataHelper<T> {
    public HelperAdapter(List<T> data, Context context, int ... layoutId) {
        super(data, context, layoutId);
    }

    @Override
    public BH onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType < 0 || viewType > this.mLayoutId.length) {
            throw new ArrayIndexOutOfBoundsException("checkLayoutIndex > LayoutId.length");
        }
        if (this.mLayoutId.length == 0) {
            throw new IllegalArgumentException("not layoutId");
        }
        int layoutId = this.mLayoutId[viewType];
        View view = this.inflateItemView(layoutId, parent);
        HelperViewHolder holder = (HelperViewHolder)view.getTag();
        if (holder == null || holder.getLayoutId() != layoutId) {
            holder = new HelperViewHolder(this.mContext, layoutId, view);
        }
        return holder;
    }

    @Override
    protected void onBindData(BH viewHolder, int position, T item) {
        HelperViewHolder helperViewHolder = (HelperViewHolder)viewHolder;
        this.HelperBindData(helperViewHolder, position, item);
        this.setListener(helperViewHolder, position, item);
    }

    protected abstract void HelperBindData(HelperViewHolder var1, int var2, T var3);

    protected void setListener(HelperViewHolder viewHolder, int position, T item) {
    }

    @Override
    public boolean isEnabled() {
        if (this.mList == null) {
            return false;
        }
        return this.mList.size() > 0;
    }

    @Override
    public void addItemToHead(T data) {
        this.add(0, data);
    }

    @Override
    public boolean addItemToLast(T data) {
        if (!this.isEnabled()) {
            this.addItemToHead(data);
            return true;
        }
        boolean result = this.mList.add(data);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public boolean addItemsToHead(List<T> datas) {
        return this.addAll(0, datas);
    }

    @Override
    public boolean addItemsToLast(List<T> datas) {
        if (!this.isEnabled()) {
            this.addItemsToHead(datas);
        }
        return this.addAll(this.mList.size() - 1, datas);
    }

    @Override
    public boolean addAll(int startPosition, List<T> datas) {
        this.initList();
        boolean result = this.mList.addAll(startPosition < 0 ? 0 : startPosition, datas);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void add(int startPosition, T data) {
        this.initList();
        this.mList.add(startPosition, data);
        this.notifyDataSetChanged();
    }

    @Override
    public T getData(int index) {
        return this.getItemCount() == 0 ? null : (T)this.mList.get(index);
    }

    @Override
    public void alterObj(T oldData, T newData) {
        this.alterObj(this.mList.indexOf(oldData), newData);
    }

    @Override
    public void alterObj(int index, T data) {
        this.initList();
        this.mList.set(index, data);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean remove(T data) {
        if (this.mList == null) {
            throw new IllegalArgumentException("list is null,cannot execute");
        }
        boolean result = this.mList.remove(data);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void removeToIndex(int index) {
        if (this.mList == null) {
            throw new IllegalArgumentException("list is null,cannot execute");
        }
        this.mList.remove(index);
        this.notifyDataSetChanged();
    }

    @Override
    public void replaceAll(List<T> data) {
        this.initList();
        this.mList.clear();
        this.addAll(0, data);
    }

    @Override
    public void clear() {
        this.initList();
        this.mList.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(T data) {
        this.initList();
        return this.mList.contains(data);
    }

    private void initList() {
        if (this.mList == null) {
            this.mList = new ArrayList();
        }
    }
}

