/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.absListView;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class BaseViewHolder {
    private SparseArray<View> mViews = new SparseArray();
    private SparseArray<View> mConvertViews = new SparseArray();
    private int mPosition;
    private View mConvertView;
    protected int mLayoutId;
    protected Context mContext;

    public BaseViewHolder(Context context, int position, ViewGroup parent, int layoutId) {
        this.mConvertView = (View)this.mConvertViews.get(layoutId);
        this.mPosition = position;
        this.mContext = context;
        this.mLayoutId = layoutId;
        if (this.mConvertView == null) {
            this.mConvertView = LayoutInflater.from((Context)context).inflate(layoutId, parent, false);
            this.mConvertViews.put(layoutId, (Object)this.mConvertView);
            this.mConvertView.setTag((Object)this);
        }
    }

    public BaseViewHolder() {
    }

    public <BH extends BaseViewHolder> BH get(Context context, int position, View convertView, ViewGroup parent, int layoutId) {
        if (convertView == null) {
            return (BH)new BaseViewHolder(context, position, parent, layoutId);
        }
        BaseViewHolder bHolder = (BaseViewHolder)convertView.getTag();
        if (bHolder.mLayoutId != layoutId) {
            return (BH)new BaseViewHolder(context, position, parent, layoutId);
        }
        bHolder.setPosition(position);
        return (BH)bHolder;
    }

    public <R extends View> R getView(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (R)view;
    }

    public View getConvertView() {
        return (View)this.mConvertViews.valueAt(0);
    }

    public View getConvertView(int layoutId) {
        return (View)this.mConvertViews.get(layoutId);
    }

    public void setPosition(int mPosition) {
        this.mPosition = mPosition;
    }

    public int getLayoutId() {
        return this.mLayoutId;
    }
}

