/*
 * Decompiled with CFR 0.152.
 */
package com.zengcanxiang.baseAdapter.recyclerView;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zengcanxiang.baseAdapter.recyclerView.BaseRecyclerViewHolder;
import java.util.List;

public abstract class BaseRecyclerViewAdapter<T>
extends RecyclerView.Adapter<BaseRecyclerViewHolder> {
    protected List<T> mList;
    protected Context mContext;
    protected LayoutInflater mLInflater;
    private int[] mLayoutId;
    private SparseArray<View> mConvertViews = new SparseArray();

    public BaseRecyclerViewAdapter(List<T> data, Context context, int ... layoutId) {
        this.mList = data;
        this.mLayoutId = layoutId;
        this.mContext = context;
        this.mLInflater = LayoutInflater.from((Context)this.mContext);
    }

    public int getItemViewType(int position) {
        return this.checkLayout(this.mList.get(position), position);
    }

    public BaseRecyclerViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType < 0 || viewType > this.mLayoutId.length) {
            throw new ArrayIndexOutOfBoundsException("checkLayout > LayoutId.length");
        }
        if (this.mLayoutId.length == 0) {
            throw new ArrayIndexOutOfBoundsException("not layoutId");
        }
        int layoutId = this.mLayoutId[viewType];
        View view = this.inflateItemView(layoutId, parent);
        BaseRecyclerViewHolder viewHolder = (BaseRecyclerViewHolder)((Object)view.getTag());
        if (viewHolder == null || viewHolder.getLayoutId() != layoutId) {
            viewHolder = new BaseRecyclerViewHolder(layoutId, view);
            return viewHolder;
        }
        return viewHolder;
    }

    protected View inflateItemView(int layoutId, ViewGroup viewGroup) {
        View convertView = (View)this.mConvertViews.get(layoutId);
        if (convertView == null) {
            convertView = this.mLInflater.inflate(layoutId, viewGroup, false);
        }
        return convertView;
    }

    public void onBindViewHolder(BaseRecyclerViewHolder holder, int position) {
        T item = this.getItem(position);
        this.onBindData(holder, position, item);
        this.setListener(this.mContext, holder, position, item);
    }

    public int getItemCount() {
        return this.mList == null ? 0 : this.mList.size();
    }

    public void addItem(T item) {
        this.mList.add(item);
        this.notifyDataSetChanged();
    }

    public void addItems(List<T> items) {
        this.mList.addAll(items);
        this.notifyDataSetChanged();
    }

    public void addItemToHead(T item) {
        this.mList.add(0, item);
        this.notifyDataSetChanged();
    }

    public void addItemsToHead(List<T> items) {
        this.mList.addAll(0, items);
        this.notifyDataSetChanged();
    }

    public void remove(int position) {
        this.mList.remove(position);
        this.notifyDataSetChanged();
    }

    public void remove(T item) {
        this.mList.remove(item);
        this.notifyDataSetChanged();
    }

    public void removeAll() {
        this.mList.clear();
        this.notifyDataSetChanged();
    }

    public T getItem(int position) {
        return this.mList.get(position);
    }

    protected abstract void onBindData(BaseRecyclerViewHolder var1, int var2, T var3);

    protected void setListener(Context context, BaseRecyclerViewHolder viewHolder, int position, T item) {
    }

    public int checkLayout(T item, int position) {
        return 0;
    }
}

