/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GtidSet {
    private final Map<String, UUIDSet> map = new LinkedHashMap<String, UUIDSet>();

    public GtidSet(String gtidSet) {
        String[] uuidSets;
        for (String uuidSet : uuidSets = gtidSet == null || gtidSet.isEmpty() ? new String[]{} : gtidSet.replace("\n", "").split(",")) {
            String[] rawIntervals;
            int uuidSeparatorIndex = uuidSet.indexOf(":");
            String sourceId = uuidSet.substring(0, uuidSeparatorIndex);
            ArrayList<Interval> intervals = new ArrayList<Interval>();
            for (String interval : rawIntervals = uuidSet.substring(uuidSeparatorIndex + 1).split(":")) {
                String[] is = interval.split("-");
                long[] split = new long[is.length];
                int e = is.length;
                for (int i = 0; i < e; ++i) {
                    split[i] = Long.parseLong(is[i]);
                }
                if (split.length == 1) {
                    split = new long[]{split[0], split[0]};
                }
                intervals.add(new Interval(split[0], split[1]));
            }
            this.map.put(sourceId, new UUIDSet(sourceId, intervals));
        }
    }

    public Collection<UUIDSet> getUUIDSets() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public UUIDSet getUUIDSet(String uuid) {
        return this.map.get(uuid);
    }

    public UUIDSet putUUIDSet(UUIDSet uuidSet) {
        return this.map.put(uuidSet.getUUID(), uuidSet);
    }

    public boolean add(String gtid) {
        String[] split = gtid.split(":");
        String sourceId = split[0];
        long transactionId = Long.parseLong(split[1]);
        UUIDSet uuidSet = this.map.get(sourceId);
        if (uuidSet == null) {
            uuidSet = new UUIDSet(sourceId, new ArrayList<Interval>());
            this.map.put(sourceId, uuidSet);
        }
        return uuidSet.add(transactionId);
    }

    public boolean isContainedWithin(GtidSet other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.equals(other)) {
            return true;
        }
        for (UUIDSet uuidSet : this.map.values()) {
            UUIDSet thatSet;
            if (uuidSet.isContainedWithin(thatSet = other.getUUIDSet(uuidSet.getUUID()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.keySet().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GtidSet) {
            GtidSet that = (GtidSet)obj;
            return this.map.equals(that.map);
        }
        return false;
    }

    public String toString() {
        ArrayList<CallSite> gtids = new ArrayList<CallSite>();
        for (UUIDSet uuidSet : this.map.values()) {
            gtids.add((CallSite)((Object)(uuidSet.getUUID() + ":" + GtidSet.join(uuidSet.intervals, ":"))));
        }
        return GtidSet.join(gtids, ",");
    }

    private static String join(Collection<?> o, String delimiter) {
        if (o.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object o1 : o) {
            sb.append(o1).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    public static final class Interval
    implements Comparable<Interval> {
        private long start;
        private long end;

        public Interval(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public boolean isContainedWithin(Interval other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            return this.getStart() >= other.getStart() && this.getEnd() <= other.getEnd();
        }

        public int hashCode() {
            return (int)this.getStart();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Interval) {
                Interval that = (Interval)obj;
                return this.getStart() == that.getStart() && this.getEnd() == that.getEnd();
            }
            return false;
        }

        public String toString() {
            return this.start + "-" + this.end;
        }

        @Override
        public int compareTo(Interval o) {
            return Interval.saturatedCast(this.start - o.start);
        }

        private static int saturatedCast(long value) {
            if (value > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (value < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)value;
        }
    }

    public static final class UUIDSet {
        private String uuid;
        private List<Interval> intervals;

        public UUIDSet(String uuid, List<Interval> intervals) {
            this.uuid = uuid;
            this.intervals = intervals;
            if (intervals.size() > 1) {
                this.joinAdjacentIntervals(0);
            }
        }

        private boolean add(long transactionId) {
            int index = this.findInterval(transactionId);
            boolean addedToExisting = false;
            if (index < this.intervals.size()) {
                Interval interval = this.intervals.get(index);
                if (interval.start == transactionId + 1L) {
                    interval.start = transactionId;
                    addedToExisting = true;
                } else if (interval.end + 1L == transactionId) {
                    interval.end = transactionId;
                    addedToExisting = true;
                } else if (interval.start <= transactionId && transactionId <= interval.end) {
                    return false;
                }
            }
            if (!addedToExisting) {
                this.intervals.add(index, new Interval(transactionId, transactionId));
            }
            if (this.intervals.size() > 1) {
                this.joinAdjacentIntervals(index);
            }
            return true;
        }

        private void joinAdjacentIntervals(int index) {
            int e = Math.max(index - 1, 0);
            for (int i = Math.min(index + 1, this.intervals.size() - 1); i > e; --i) {
                Interval a = this.intervals.get(i - 1);
                Interval b = this.intervals.get(i);
                if (a.end + 1L != b.start) continue;
                a.end = b.end;
                this.intervals.remove(i);
            }
        }

        private int findInterval(long v) {
            int l = 0;
            int p = 0;
            int r = this.intervals.size();
            while (l < r) {
                p = (l + r) / 2;
                Interval i = this.intervals.get(p);
                if (i.end < v) {
                    l = p + 1;
                    continue;
                }
                if (v < i.start) {
                    r = p;
                    continue;
                }
                return p;
            }
            if (!this.intervals.isEmpty() && this.intervals.get((int)p).end < v) {
                ++p;
            }
            return p;
        }

        public String getUUID() {
            return this.uuid;
        }

        public List<Interval> getIntervals() {
            return Collections.unmodifiableList(this.intervals);
        }

        public boolean isContainedWithin(UUIDSet other) {
            if (other == null) {
                return false;
            }
            if (!this.getUUID().equalsIgnoreCase(other.getUUID())) {
                return false;
            }
            if (this.intervals.isEmpty()) {
                return true;
            }
            if (other.intervals.isEmpty()) {
                return false;
            }
            for (Interval thisInterval : this.intervals) {
                boolean found = false;
                for (Interval otherInterval : other.intervals) {
                    if (!thisInterval.isContainedWithin(otherInterval)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof UUIDSet) {
                UUIDSet that = (UUIDSet)obj;
                return this.getUUID().equalsIgnoreCase(that.getUUID()) && this.getIntervals().equals(that.getIntervals());
            }
            return super.equals(obj);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(this.uuid).append(':');
            Iterator<Interval> iter = this.intervals.iterator();
            if (iter.hasNext()) {
                sb.append(iter.next());
            }
            while (iter.hasNext()) {
                sb.append(':');
                sb.append(iter.next());
            }
            return sb.toString();
        }
    }
}

