/*
 * Decompiled with CFR 0.152.
 */
package com.app.progresviews;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.app.progreswheelview.R;

public class ProgressWheel
extends View {
    private float mBarWidth = 24.0f;
    private float mCountTextSize = 48.0f;
    private float mDefTextSize = 24.0f;
    private int layoutHeight = 0;
    private int layoutWidth = 0;
    private int mProgressColor = -16711936;
    private int mRimColor = -286331154;
    private int mCountTextColor = -16777216;
    private int mDefTextColor = -16777216;
    private int paddingTop = 5;
    private int paddingBottom = 5;
    private int paddingLeft = 5;
    private int paddingRight = 5;
    private RectF mRimBounds = new RectF();
    private RectF mProgressBounds = new RectF();
    private Paint mCirclePaint = new Paint();
    private Paint mBarPaint = new Paint();
    private TextPaint mCountTextPaint = new TextPaint();
    private TextPaint mDefTextPaint = new TextPaint();
    private String mCountText = "10,000";
    private String mDefText = "Steps";
    private float mCountTextWidth;
    private float mCountTextHeight;
    private float mDefTextHeight;
    private float mDefTextWidth;
    private int mPercentage = 60;

    public ProgressWheel(Context context) {
        super(context);
        this.init(null, 0);
    }

    public ProgressWheel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public ProgressWheel(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.layoutWidth = w;
        this.layoutHeight = h;
        this.setupBounds();
        this.setupPaints();
        this.invalidate();
    }

    private void setupPaints() {
        this.mBarPaint.setColor(this.mProgressColor);
        this.mBarPaint.setAntiAlias(true);
        this.mBarPaint.setStyle(Paint.Style.STROKE);
        this.mBarPaint.setStrokeWidth(this.mBarWidth);
        this.mBarPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mCirclePaint.setColor(this.mRimColor);
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setStyle(Paint.Style.STROKE);
        this.mCirclePaint.setStrokeWidth(this.mBarWidth);
        this.mCountTextPaint.setColor(this.mCountTextColor);
        this.mCountTextPaint.setFlags(1);
        this.mDefTextPaint.setColor(this.mDefTextColor);
        this.mDefTextPaint.setFlags(1);
    }

    private void setupBounds() {
        int minValue = Math.min(this.layoutWidth, this.layoutHeight);
        int xOffset = this.layoutWidth - minValue;
        int yOffset = this.layoutHeight - minValue;
        this.paddingTop = this.getPaddingTop() + yOffset / 2;
        this.paddingBottom = this.getPaddingBottom() + yOffset / 2;
        this.paddingLeft = this.getPaddingLeft() + xOffset / 2;
        this.paddingRight = this.getPaddingRight() + xOffset / 2;
        int width = this.getWidth();
        int height = this.getHeight();
        this.mRimBounds = new RectF((float)this.paddingLeft + this.mBarWidth, (float)this.paddingTop + this.mBarWidth, (float)(width - this.paddingRight) - this.mBarWidth, (float)(height - this.paddingBottom) - this.mBarWidth);
        this.mProgressBounds = new RectF((float)this.paddingLeft + this.mBarWidth, (float)this.paddingTop + this.mBarWidth, (float)(width - this.paddingRight) - this.mBarWidth, (float)(height - this.paddingBottom) - this.mBarWidth);
        this.mCountTextPaint.setTextSize(this.mCountTextSize);
        Paint.FontMetrics fontMetrics = this.mCountTextPaint.getFontMetrics();
        this.mCountTextHeight = fontMetrics.bottom;
        this.mCountTextWidth = this.mCountTextPaint.measureText(this.mCountText == null || this.mCountText.isEmpty() ? " " : this.mCountText);
        this.mDefTextPaint.setTextSize(this.mDefTextSize);
        Paint.FontMetrics fontDefMetrics = this.mDefTextPaint.getFontMetrics();
        this.mDefTextHeight = fontDefMetrics.bottom;
        this.mDefTextWidth = this.mDefTextPaint.measureText(this.mDefText == null || this.mDefText.isEmpty() ? " " : this.mDefText);
    }

    private void init(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ProgressWheel, defStyle, 0);
        if (a.hasValue(R.styleable.ProgressWheel_countText)) {
            this.mCountText = a.getString(R.styleable.ProgressWheel_countText);
        }
        if (a.hasValue(R.styleable.ProgressWheel_definitionText)) {
            this.mDefText = a.getString(R.styleable.ProgressWheel_definitionText);
        }
        this.mBarWidth = a.getDimension(R.styleable.ProgressWheel_barWidth, this.mBarWidth);
        this.mProgressColor = a.getColor(R.styleable.ProgressWheel_progressColor, this.mProgressColor);
        this.mRimColor = a.getColor(R.styleable.ProgressWheel_rimColor, this.mRimColor);
        this.mCountTextColor = a.getColor(R.styleable.ProgressWheel_countTextColor, this.mCountTextColor);
        this.mDefTextColor = a.getColor(R.styleable.ProgressWheel_defTextColor, this.mDefTextColor);
        this.mCountTextSize = a.getDimension(R.styleable.ProgressWheel_countTextSize, this.mCountTextSize);
        this.mDefTextSize = a.getDimension(R.styleable.ProgressWheel_defTextSize, this.mDefTextSize);
        this.mPercentage = a.getInt(R.styleable.ProgressWheel_percentage, this.mPercentage);
        a.recycle();
        this.mCountTextPaint = new TextPaint();
        this.mCountTextPaint.setFlags(1);
        this.mCountTextPaint.setTextAlign(Paint.Align.LEFT);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawArc(this.mRimBounds, 0.0f, 360.0f, false, this.mCirclePaint);
        canvas.drawArc(this.mProgressBounds, -90.0f, (float)this.mPercentage, false, this.mBarPaint);
        float horizontalCountTextOffset = this.mCountTextPaint.measureText(this.mCountText) / 2.0f;
        canvas.drawText(this.mCountText, (float)(this.getWidth() / 2) - horizontalCountTextOffset, (float)(this.getHeight() / 2), (Paint)this.mCountTextPaint);
        float horizontalDefTextOffset = this.mDefTextPaint.measureText(this.mDefText) / 2.0f;
        canvas.drawText(this.mDefText, (float)(this.getWidth() / 2) - horizontalDefTextOffset, (float)(this.getHeight() / 2) + this.mCountTextHeight + 20.0f, (Paint)this.mDefTextPaint);
    }

    public void setStepCountText(String countText) {
        this.mCountText = countText;
        this.invalidate();
    }

    public void setDefText(String defText) {
        this.mDefText = defText;
        this.invalidate();
    }

    public void setPercentage(int per) {
        this.mPercentage = per;
        this.invalidate();
    }
}

