/*
 * Decompiled with CFR 0.152.
 */
package com.customfabs.animation;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.graphics.Point;
import android.util.Property;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import com.customfabs.FloatingActionMenu;
import com.customfabs.animation.MenuAnimationHandler;

public class DefaultAnimationHandler
extends MenuAnimationHandler {
    protected static final int DURATION = 500;
    protected static final int LAG_BETWEEN_ITEMS = 20;
    private static final long LAG_CLOSING_BACK_PANEL = 100L;
    private boolean animating;

    public DefaultAnimationHandler() {
        this.setAnimating(false);
    }

    @Override
    public void animateMenuOpening(Point center) {
        super.animateMenuOpening(center);
        this.setAnimating(true);
        if (this.menu.getBackPanelView() != null) {
            this.openPanel(center);
        }
        ObjectAnimator lastAnimation = null;
        for (int i = 0; i < this.menu.getSubActionItems().size(); ++i) {
            this.menu.getSubActionItems().get((int)i).view.setScaleX(0.0f);
            this.menu.getSubActionItems().get((int)i).view.setScaleY(0.0f);
            this.menu.getSubActionItems().get((int)i).view.setAlpha(0.0f);
            PropertyValuesHolder pvhX = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{this.menu.getSubActionItems().get((int)i).x - center.x + this.menu.getSubActionItems().get((int)i).width / 2});
            PropertyValuesHolder pvhY = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{this.menu.getSubActionItems().get((int)i).y - center.y + this.menu.getSubActionItems().get((int)i).height / 2});
            PropertyValuesHolder pvhR = PropertyValuesHolder.ofFloat((Property)View.ROTATION, (float[])new float[]{720.0f});
            PropertyValuesHolder pvhsX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f});
            PropertyValuesHolder pvhsY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f});
            PropertyValuesHolder pvhA = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f});
            ObjectAnimator animation = ObjectAnimator.ofPropertyValuesHolder((Object)this.menu.getSubActionItems().get((int)i).view, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhX, pvhY, pvhR, pvhsX, pvhsY, pvhA});
            animation.setDuration(500L);
            animation.setInterpolator((TimeInterpolator)new OvershootInterpolator(0.9f));
            animation.addListener((Animator.AnimatorListener)new SubActionItemAnimationListener(this.menu.getSubActionItems().get(i), MenuAnimationHandler.ActionType.OPENING));
            if (i == 0) {
                lastAnimation = animation;
            }
            animation.setStartDelay((long)((this.menu.getSubActionItems().size() - i) * 20));
            animation.start();
        }
        if (lastAnimation != null) {
            lastAnimation.addListener((Animator.AnimatorListener)new MenuAnimationHandler.LastAnimationListener(this));
        }
    }

    @Override
    public void animateMenuClosing(Point center) {
        super.animateMenuOpening(center);
        this.setAnimating(true);
        ObjectAnimator lastAnimation = null;
        for (int i = 0; i < this.menu.getSubActionItems().size(); ++i) {
            PropertyValuesHolder pvhX = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{-(this.menu.getSubActionItems().get((int)i).x - center.x + this.menu.getSubActionItems().get((int)i).width / 2)});
            PropertyValuesHolder pvhY = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{-(this.menu.getSubActionItems().get((int)i).y - center.y + this.menu.getSubActionItems().get((int)i).height / 2)});
            PropertyValuesHolder pvhR = PropertyValuesHolder.ofFloat((Property)View.ROTATION, (float[])new float[]{-720.0f});
            PropertyValuesHolder pvhsX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.0f});
            PropertyValuesHolder pvhsY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.0f});
            PropertyValuesHolder pvhA = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.0f});
            ObjectAnimator animation = ObjectAnimator.ofPropertyValuesHolder((Object)this.menu.getSubActionItems().get((int)i).view, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhX, pvhY, pvhR, pvhsX, pvhsY, pvhA});
            animation.setDuration(500L);
            animation.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            animation.addListener((Animator.AnimatorListener)new SubActionItemAnimationListener(this.menu.getSubActionItems().get(i), MenuAnimationHandler.ActionType.CLOSING));
            if (i == 0) {
                lastAnimation = animation;
            }
            animation.setStartDelay((long)((this.menu.getSubActionItems().size() - i) * 20));
            animation.start();
        }
        if (this.menu.getBackPanelView() != null) {
            lastAnimation = this.closePanel(center);
        }
        if (lastAnimation != null) {
            lastAnimation.addListener((Animator.AnimatorListener)new MenuAnimationHandler.LastAnimationListener(this));
        }
    }

    private ObjectAnimator openPanel(Point center) {
        this.menu.getBackPanelView().view.setScaleX(0.0f);
        this.menu.getBackPanelView().view.setScaleY(0.0f);
        this.menu.getBackPanelView().view.setAlpha(0.0f);
        PropertyValuesHolder pvhX = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{this.menu.getBackPanelView().x - center.x + this.menu.getBackPanelView().width / 2});
        PropertyValuesHolder pvhY = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{this.menu.getBackPanelView().y - center.y + this.menu.getBackPanelView().height / 2});
        PropertyValuesHolder pvhR = PropertyValuesHolder.ofFloat((Property)View.ROTATION, (float[])new float[]{0.0f});
        PropertyValuesHolder pvhsX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f});
        PropertyValuesHolder pvhsY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f});
        PropertyValuesHolder pvhA = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f});
        ObjectAnimator animation = ObjectAnimator.ofPropertyValuesHolder((Object)this.menu.getBackPanelView().view, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhX, pvhY, pvhR, pvhsX, pvhsY, pvhA});
        animation.setDuration(500L);
        animation.setInterpolator((TimeInterpolator)new OvershootInterpolator(0.9f));
        animation.addListener((Animator.AnimatorListener)new SubActionItemAnimationListener(this.menu.getBackPanelView(), MenuAnimationHandler.ActionType.OPENING));
        animation.start();
        return animation;
    }

    private ObjectAnimator closePanel(Point center) {
        PropertyValuesHolder pvhX = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{-(this.menu.getBackPanelView().x - center.x + this.menu.getBackPanelView().width / 2)});
        PropertyValuesHolder pvhY = PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{-(this.menu.getBackPanelView().y - center.y + this.menu.getBackPanelView().height / 2)});
        PropertyValuesHolder pvhR = PropertyValuesHolder.ofFloat((Property)View.ROTATION, (float[])new float[]{0.0f});
        PropertyValuesHolder pvhsX = PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{0.0f});
        PropertyValuesHolder pvhsY = PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{0.0f});
        PropertyValuesHolder pvhA = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.0f});
        ObjectAnimator animation = ObjectAnimator.ofPropertyValuesHolder((Object)this.menu.getBackPanelView().view, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhX, pvhY, pvhR, pvhsX, pvhsY, pvhA});
        animation.setDuration(500L);
        animation.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animation.addListener((Animator.AnimatorListener)new SubActionItemAnimationListener(this.menu.getBackPanelView(), MenuAnimationHandler.ActionType.CLOSING));
        animation.setStartDelay(100L);
        animation.start();
        return animation;
    }

    @Override
    public boolean isAnimating() {
        return this.animating;
    }

    @Override
    protected void setAnimating(boolean animating) {
        this.animating = animating;
    }

    protected class SubActionItemAnimationListener
    implements Animator.AnimatorListener {
        private FloatingActionMenu.Item subActionItem;
        private MenuAnimationHandler.ActionType actionType;

        public SubActionItemAnimationListener(FloatingActionMenu.Item subActionItem, MenuAnimationHandler.ActionType actionType) {
            this.subActionItem = subActionItem;
            this.actionType = actionType;
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            DefaultAnimationHandler.this.restoreSubActionViewAfterAnimation(this.subActionItem, this.actionType);
        }

        public void onAnimationCancel(Animator animation) {
            DefaultAnimationHandler.this.restoreSubActionViewAfterAnimation(this.subActionItem, this.actionType);
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }
}

