/*
 * Decompiled with CFR 0.152.
 */
package com.customfabs;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.customfabs.R;
import com.customfabs.animation.DefaultAnimationHandler;
import com.customfabs.animation.MenuAnimationHandler;
import java.util.ArrayList;
import java.util.List;

public class FloatingActionMenu {
    private View mainActionView;
    private int startAngle;
    private int endAngle;
    private int radius;
    private List<Item> subActionItems;
    private Item backPanelView;
    private MenuAnimationHandler animationHandler;
    private MenuStateChangeListener stateChangeListener;
    private boolean animated;
    private boolean open;
    private boolean systemOverlay;
    private View mMainContent = null;
    private FrameLayout overlayContainer;
    private OrientationEventListener orientationListener;

    public FloatingActionMenu(View mainActionView, int startAngle, int endAngle, int radius, List<Item> subActionItems, Item backPanelView, MenuAnimationHandler animationHandler, boolean animated, MenuStateChangeListener stateChangeListener, boolean systemOverlay, View mainContent) {
        this.mainActionView = mainActionView;
        this.startAngle = startAngle;
        this.endAngle = endAngle;
        this.radius = radius;
        this.subActionItems = subActionItems;
        this.backPanelView = backPanelView;
        this.animationHandler = animationHandler;
        this.animated = animated;
        this.systemOverlay = systemOverlay;
        this.mMainContent = mainContent;
        this.open = false;
        this.stateChangeListener = stateChangeListener;
        this.mainActionView.setClickable(true);
        this.mainActionView.setOnClickListener((View.OnClickListener)new ActionViewClickListener());
        if (animationHandler != null) {
            animationHandler.setMenu(this);
        }
        this.overlayContainer = systemOverlay ? new FrameLayout(mainActionView.getContext()) : null;
        for (Item item : subActionItems) {
            if (item.width != 0 && item.height != 0) continue;
            if (systemOverlay) {
                throw new RuntimeException("Sub action views cannot be added without definite width and height.");
            }
            this.addViewToCurrentContainer(item.view);
            item.view.setAlpha(0.0f);
            item.view.post((Runnable)new ItemViewQueueListener(item));
        }
        this.attachBackPanelSize(backPanelView);
        if (systemOverlay) {
            this.orientationListener = new OrientationEventListener(mainActionView.getContext(), 2){
                private int lastState;
                {
                    this.lastState = -1;
                }

                public void onOrientationChanged(int orientation) {
                    Display display = FloatingActionMenu.this.getWindowManager().getDefaultDisplay();
                    if (display.getRotation() != this.lastState) {
                        this.lastState = display.getRotation();
                        if (FloatingActionMenu.this.isOpen()) {
                            FloatingActionMenu.this.close(false);
                        }
                    }
                }
            };
            this.orientationListener.enable();
        }
    }

    private void attachBackPanelSize(Item backPanelView) {
        if (backPanelView == null) {
            return;
        }
        if (backPanelView.width == 0 || backPanelView.height == 0) {
            this.addViewToBackOfCurrentContainer(backPanelView.view);
            backPanelView.view.setAlpha(0.0f);
            backPanelView.view.post((Runnable)new ItemViewQueueListener(backPanelView));
        }
    }

    public void open(boolean animated) {
        Point center = this.calculateItemPositions();
        WindowManager.LayoutParams overlayParams = null;
        if (this.systemOverlay) {
            this.attachOverlayContainer();
            overlayParams = (WindowManager.LayoutParams)this.overlayContainer.getLayoutParams();
        }
        if (animated && this.animationHandler != null) {
            if (this.animationHandler.isAnimating()) {
                return;
            }
            this.addBackPanel(center, overlayParams);
            for (int i = 0; i < this.subActionItems.size(); ++i) {
                if (this.subActionItems.get((int)i).view.getParent() != null) {
                    throw new RuntimeException("All of the sub action items have to be independent from a parent.");
                }
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(this.subActionItems.get((int)i).width, this.subActionItems.get((int)i).height, 51);
                if (this.systemOverlay) {
                    params.setMargins(center.x - overlayParams.x - this.subActionItems.get((int)i).width / 2, center.y - overlayParams.y - this.subActionItems.get((int)i).height / 2, 0, 0);
                } else {
                    params.setMargins(center.x - this.subActionItems.get((int)i).width / 2, center.y - this.subActionItems.get((int)i).height / 2, 0, 0);
                }
                this.addViewToCurrentContainer(this.subActionItems.get((int)i).view, (ViewGroup.LayoutParams)params);
            }
            this.animationHandler.animateMenuOpening(center);
        } else {
            for (int i = 0; i < this.subActionItems.size(); ++i) {
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(this.subActionItems.get((int)i).width, this.subActionItems.get((int)i).height, 51);
                if (this.systemOverlay) {
                    params.setMargins(this.subActionItems.get((int)i).x - overlayParams.x, this.subActionItems.get((int)i).y - overlayParams.y, 0, 0);
                    this.subActionItems.get((int)i).view.setLayoutParams((ViewGroup.LayoutParams)params);
                } else {
                    params.setMargins(this.subActionItems.get((int)i).x, this.subActionItems.get((int)i).y, 0, 0);
                    this.subActionItems.get((int)i).view.setLayoutParams((ViewGroup.LayoutParams)params);
                }
                this.addViewToCurrentContainer(this.subActionItems.get((int)i).view, (ViewGroup.LayoutParams)params);
            }
        }
        this.open = true;
        if (this.stateChangeListener != null) {
            this.stateChangeListener.onMenuOpened(this);
        }
    }

    private void addBackPanel(Point center, WindowManager.LayoutParams overlayParams) {
        if (this.backPanelView == null) {
            return;
        }
        if (this.backPanelView.view.getParent() != null) {
            throw new RuntimeException("Back panel of FAB button have to be independent from a parent.");
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(this.backPanelView.width, this.backPanelView.height, 51);
        if (this.systemOverlay) {
            params.setMargins(center.x - overlayParams.x - this.backPanelView.width / 2, center.y - overlayParams.y - this.backPanelView.height / 2, 0, 0);
        } else {
            params.setMargins(center.x - this.backPanelView.width / 2, center.y - this.backPanelView.height / 2, 0, 0);
        }
        this.addViewToBackOfCurrentContainer(this.backPanelView.view, (ViewGroup.LayoutParams)params);
    }

    public void close(boolean animated) {
        if (animated && this.animationHandler != null) {
            if (this.animationHandler.isAnimating()) {
                return;
            }
            this.animationHandler.animateMenuClosing(this.getActionViewCenter());
        } else {
            for (int i = 0; i < this.subActionItems.size(); ++i) {
                this.removeViewFromCurrentContainer(this.subActionItems.get((int)i).view);
            }
            this.detachOverlayContainer();
        }
        this.open = false;
        if (this.stateChangeListener != null) {
            this.stateChangeListener.onMenuClosed(this);
        }
    }

    public void toggle(boolean animated) {
        if (this.open) {
            this.close(animated);
        } else {
            this.open(animated);
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isSystemOverlay() {
        return this.systemOverlay;
    }

    public FrameLayout getOverlayContainer() {
        return this.overlayContainer;
    }

    public void updateItemPositions() {
        if (!this.isOpen()) {
            return;
        }
        this.calculateItemPositions();
        for (int i = 0; i < this.subActionItems.size(); ++i) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(this.subActionItems.get((int)i).width, this.subActionItems.get((int)i).height, 51);
            params.setMargins(this.subActionItems.get((int)i).x, this.subActionItems.get((int)i).y, 0, 0);
            this.subActionItems.get((int)i).view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private Point getActionViewCoordinates() {
        int[] coords = new int[2];
        this.mainActionView.getLocationOnScreen(coords);
        if (this.systemOverlay) {
            coords[1] = coords[1] - this.getStatusBarHeight();
        } else {
            Rect activityFrame = new Rect();
            this.getActivityContentView().getWindowVisibleDisplayFrame(activityFrame);
            coords[0] = coords[0] - (this.getScreenSize().x - this.getActivityContentView().getMeasuredWidth());
            coords[1] = coords[1] - (activityFrame.height() + activityFrame.top - this.getActivityContentView().getMeasuredHeight());
        }
        return new Point(coords[0], coords[1]);
    }

    public View getMainActionView() {
        return this.mainActionView;
    }

    public Point getActionViewCenter() {
        Point point = this.getActionViewCoordinates();
        point.x += this.mainActionView.getMeasuredWidth() / 2;
        point.y += this.mainActionView.getMeasuredHeight() / 2;
        return point;
    }

    private Point calculateItemPositions() {
        Point center = this.getActionViewCenter();
        RectF area = new RectF((float)(center.x - this.radius), (float)(center.y - this.radius), (float)(center.x + this.radius), (float)(center.y + this.radius));
        Path orbit = new Path();
        orbit.addArc(area, (float)this.startAngle, (float)(this.endAngle - this.startAngle));
        PathMeasure measure = new PathMeasure(orbit, false);
        int divisor = Math.abs(this.endAngle - this.startAngle) >= 360 || this.subActionItems.size() <= 1 ? this.subActionItems.size() : this.subActionItems.size() - 1;
        for (int i = 0; i < this.subActionItems.size(); ++i) {
            float[] coords = new float[]{0.0f, 0.0f};
            measure.getPosTan((float)i * measure.getLength() / (float)divisor, coords, null);
            this.subActionItems.get((int)i).x = (int)coords[0] - this.subActionItems.get((int)i).width / 2;
            this.subActionItems.get((int)i).y = (int)coords[1] - this.subActionItems.get((int)i).height / 2;
        }
        this.backPanelView.x = center.x - this.backPanelView.width / 2;
        this.backPanelView.y = center.y - this.backPanelView.height / 2;
        return center;
    }

    public int getRadius() {
        return this.radius;
    }

    public List<Item> getSubActionItems() {
        return this.subActionItems;
    }

    public Item getBackPanelView() {
        return this.backPanelView;
    }

    public View getActivityContentView() {
        try {
            if (this.mMainContent != null) {
                return this.mMainContent;
            }
            if (this.mainActionView.getContext() instanceof ContextWrapper) {
                return ((Activity)((ContextWrapper)this.mainActionView.getContext()).getBaseContext()).getWindow().getDecorView().findViewById(0x1020002);
            }
            return ((Activity)this.mainActionView.getContext()).getWindow().getDecorView().findViewById(0x1020002);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Please provide an Activity context for this FloatingActionMenu.");
        }
    }

    public WindowManager getWindowManager() {
        return (WindowManager)this.mainActionView.getContext().getSystemService("window");
    }

    private void addViewToCurrentContainer(View view, ViewGroup.LayoutParams layoutParams) {
        if (this.systemOverlay) {
            this.overlayContainer.addView(view, layoutParams);
        } else {
            try {
                if (layoutParams != null) {
                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)layoutParams;
                    ((ViewGroup)this.getActivityContentView()).addView(view, (ViewGroup.LayoutParams)lp);
                } else {
                    ((ViewGroup)this.getActivityContentView()).addView(view);
                }
            }
            catch (ClassCastException e) {
                throw new ClassCastException("layoutParams must be an instance of FrameLayout.LayoutParams.");
            }
        }
    }

    private void addViewToBackOfCurrentContainer(View view) {
        this.addViewToBackOfCurrentContainer(view, null);
    }

    private void addViewToBackOfCurrentContainer(View view, ViewGroup.LayoutParams layoutParams) {
        if (this.systemOverlay) {
            this.overlayContainer.addView(view, layoutParams);
        } else {
            try {
                if (layoutParams != null) {
                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)layoutParams;
                    ((ViewGroup)this.getActivityContentView()).addView(view, (ViewGroup.LayoutParams)lp);
                } else {
                    ((ViewGroup)this.getActivityContentView()).addView(view);
                }
            }
            catch (ClassCastException e) {
                throw new ClassCastException("layoutParams must be an instance of FrameLayout.LayoutParams.");
            }
        }
    }

    public void attachOverlayContainer() {
        try {
            WindowManager.LayoutParams overlayParams = this.calculateOverlayContainerParams();
            this.overlayContainer.setLayoutParams((ViewGroup.LayoutParams)overlayParams);
            if (this.overlayContainer.getParent() == null) {
                this.getWindowManager().addView((View)this.overlayContainer, (ViewGroup.LayoutParams)overlayParams);
            }
            this.getWindowManager().updateViewLayout(this.mainActionView, this.mainActionView.getLayoutParams());
        }
        catch (SecurityException e) {
            throw new SecurityException("Your application must have SYSTEM_ALERT_WINDOW permission to create a system window.");
        }
    }

    private WindowManager.LayoutParams calculateOverlayContainerParams() {
        WindowManager.LayoutParams overlayParams = FloatingActionMenu.getDefaultSystemWindowParams();
        int left = 9999;
        int right = 0;
        int top = 9999;
        int bottom = 0;
        for (int i = 0; i < this.subActionItems.size(); ++i) {
            int lm = this.subActionItems.get((int)i).x;
            int tm = this.subActionItems.get((int)i).y;
            if (lm < left) {
                left = lm;
            }
            if (tm < top) {
                top = tm;
            }
            if (lm + this.subActionItems.get((int)i).width > right) {
                right = lm + this.subActionItems.get((int)i).width;
            }
            if (tm + this.subActionItems.get((int)i).height <= bottom) continue;
            bottom = tm + this.subActionItems.get((int)i).height;
        }
        overlayParams.width = right - left;
        overlayParams.height = bottom - top;
        overlayParams.x = left;
        overlayParams.y = top;
        overlayParams.gravity = 51;
        return overlayParams;
    }

    public void detachOverlayContainer() {
        this.getWindowManager().removeView((View)this.overlayContainer);
    }

    public int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.mainActionView.getContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.mainActionView.getContext().getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public void addViewToCurrentContainer(View view) {
        this.addViewToCurrentContainer(view, null);
    }

    public void removeViewFromCurrentContainer(View view) {
        if (this.systemOverlay) {
            this.overlayContainer.removeView(view);
        } else {
            ((ViewGroup)this.getActivityContentView()).removeView(view);
        }
    }

    private Point getScreenSize() {
        Point size = new Point();
        this.getWindowManager().getDefaultDisplay().getSize(size);
        return size;
    }

    public void setStateChangeListener(MenuStateChangeListener listener) {
        this.stateChangeListener = listener;
    }

    public static WindowManager.LayoutParams getDefaultSystemWindowParams() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams(-2, -2, 2002, 40, -3);
        params.format = 1;
        params.gravity = 51;
        return params;
    }

    public static class Builder {
        private int startAngle;
        private int endAngle;
        private int radius;
        private View actionView;
        private List<Item> subActionItems = new ArrayList<Item>();
        private Item backPanelView;
        private MenuAnimationHandler animationHandler;
        private boolean animated;
        private MenuStateChangeListener stateChangeListener;
        private boolean systemOverlay;
        private View mMainContent;

        public Builder(Context context, boolean systemOverlay) {
            this.radius = context.getResources().getDimensionPixelSize(R.dimen.action_menu_radius);
            this.startAngle = 180;
            this.endAngle = 270;
            this.animationHandler = new DefaultAnimationHandler();
            this.animated = true;
            this.systemOverlay = systemOverlay;
        }

        public Builder(Context context) {
            this(context, false);
        }

        public Builder setStartAngle(int startAngle) {
            this.startAngle = startAngle;
            return this;
        }

        public Builder setEndAngle(int endAngle) {
            this.endAngle = endAngle;
            return this;
        }

        public Builder setRadius(int radius) {
            this.radius = radius;
            return this;
        }

        public Builder addSubActionView(View subActionView, int width, int height) {
            this.subActionItems.add(new Item(subActionView, width, height));
            return this;
        }

        public Builder addBackPanelView(View backPanelView) {
            if (this.systemOverlay) {
                throw new RuntimeException("Sub action views cannot be added without definite width and height. Please use other methods named addSubActionView");
            }
            return this.addBackPanelView(backPanelView, 0);
        }

        public Builder addBackPanelView(View backPanelView, int size) {
            this.backPanelView = new Item(backPanelView, size, size);
            return this;
        }

        public Builder addSubActionView(View subActionView) {
            if (this.systemOverlay) {
                throw new RuntimeException("Sub action views cannot be added without definite width and height. Please use other methods named addSubActionView");
            }
            return this.addSubActionView(subActionView, 0, 0);
        }

        public Builder addSubActionView(int resId, Context context) {
            LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
            View view = inflater.inflate(resId, null, false);
            view.measure(0, 0);
            return this.addSubActionView(view, view.getMeasuredWidth(), view.getMeasuredHeight());
        }

        public Builder setAnimationHandler(MenuAnimationHandler animationHandler) {
            this.animationHandler = animationHandler;
            return this;
        }

        public Builder enableAnimations() {
            this.animated = true;
            return this;
        }

        public Builder disableAnimations() {
            this.animated = false;
            return this;
        }

        public Builder setStateChangeListener(MenuStateChangeListener listener) {
            this.stateChangeListener = listener;
            return this;
        }

        public Builder setSystemOverlay(boolean systemOverlay) {
            this.systemOverlay = systemOverlay;
            return this;
        }

        public Builder attachTo(View actionView) {
            this.actionView = actionView;
            return this;
        }

        public Builder onMainContent(View mainContent) {
            this.mMainContent = mainContent;
            return this;
        }

        public FloatingActionMenu build() {
            return new FloatingActionMenu(this.actionView, this.startAngle, this.endAngle, this.radius, this.subActionItems, this.backPanelView, this.animationHandler, this.animated, this.stateChangeListener, this.systemOverlay, this.mMainContent);
        }
    }

    public static interface MenuStateChangeListener {
        public void onMenuOpened(FloatingActionMenu var1);

        public void onMenuClosed(FloatingActionMenu var1);
    }

    public static class Item {
        public int x;
        public int y;
        public int width;
        public int height;
        public float alpha;
        public View view;

        public Item(View view, int width, int height) {
            this.view = view;
            this.width = width;
            this.height = height;
            this.alpha = view.getAlpha();
            this.x = 0;
            this.y = 0;
        }
    }

    private class ItemViewQueueListener
    implements Runnable {
        private static final int MAX_TRIES = 10;
        private Item item;
        private int tries;

        public ItemViewQueueListener(Item item) {
            this.item = item;
            this.tries = 0;
        }

        @Override
        public void run() {
            if (this.item.view.getMeasuredWidth() == 0 && this.tries < 10) {
                this.item.view.post((Runnable)this);
                return;
            }
            this.item.width = this.item.view.getMeasuredWidth();
            this.item.height = this.item.view.getMeasuredHeight();
            this.item.view.setAlpha(this.item.alpha);
            FloatingActionMenu.this.removeViewFromCurrentContainer(this.item.view);
        }
    }

    public class ActionViewClickListener
    implements View.OnClickListener {
        public void onClick(View v) {
            FloatingActionMenu.this.toggle(FloatingActionMenu.this.animated);
        }
    }
}

