/*
 * Decompiled with CFR 0.152.
 */
package com.customfabs;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.customfabs.R;

public class FloatingActionButton
extends FrameLayout {
    public static final int THEME_LIGHT = 0;
    public static final int THEME_DARK = 1;
    public static final int POSITION_TOP_CENTER = 1;
    public static final int POSITION_TOP_RIGHT = 2;
    public static final int POSITION_RIGHT_CENTER = 3;
    public static final int POSITION_BOTTOM_RIGHT = 4;
    public static final int POSITION_BOTTOM_CENTER = 5;
    public static final int POSITION_BOTTOM_LEFT = 6;
    public static final int POSITION_LEFT_CENTER = 7;
    public static final int POSITION_TOP_LEFT = 8;
    private View contentView;
    private boolean systemOverlay;

    public FloatingActionButton(Context context, ViewGroup.LayoutParams layoutParams, int theme, Drawable backgroundDrawable, int position, View contentView, FrameLayout.LayoutParams contentParams, boolean systemOverlay) {
        super(context);
        this.systemOverlay = systemOverlay;
        if (!systemOverlay && !(context instanceof Activity)) {
            throw new RuntimeException("Given context must be an instance of Activity, since this FAB is not a systemOverlay.");
        }
        this.setPosition(position, layoutParams);
        if (backgroundDrawable == null) {
            backgroundDrawable = theme == 0 ? context.getResources().getDrawable(R.drawable.button_action_selector) : context.getResources().getDrawable(R.drawable.button_action_dark_selector);
        }
        this.setBackgroundResource(backgroundDrawable);
        if (contentView != null) {
            this.setContentView(contentView, contentParams);
        }
        this.setClickable(true);
        this.attach(layoutParams);
    }

    public void setPosition(int position, ViewGroup.LayoutParams layoutParams) {
        int gravity;
        boolean setDefaultMargin = false;
        switch (position) {
            case 1: {
                gravity = 49;
                break;
            }
            case 2: {
                gravity = 53;
                break;
            }
            case 3: {
                gravity = 21;
                break;
            }
            case 5: {
                gravity = 81;
                break;
            }
            case 6: {
                gravity = 83;
                break;
            }
            case 7: {
                gravity = 19;
                break;
            }
            case 8: {
                gravity = 51;
                break;
            }
            default: {
                setDefaultMargin = true;
                gravity = 85;
            }
        }
        if (!this.systemOverlay) {
            try {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)layoutParams;
                lp.gravity = gravity;
                this.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
            catch (ClassCastException e) {
                throw new ClassCastException("layoutParams must be an instance of FrameLayout.LayoutParams, since this FAB is not a systemOverlay");
            }
        }
        try {
            WindowManager.LayoutParams lp = (WindowManager.LayoutParams)layoutParams;
            lp.gravity = gravity;
            if (setDefaultMargin) {
                int margin;
                lp.x = margin = this.getContext().getResources().getDimensionPixelSize(R.dimen.action_button_margin);
                lp.y = margin;
            }
            this.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("layoutParams must be an instance of WindowManager.LayoutParams, since this FAB is a systemOverlay");
        }
    }

    public void setContentView(View contentView, FrameLayout.LayoutParams contentParams) {
        FrameLayout.LayoutParams params;
        this.contentView = contentView;
        if (contentParams == null) {
            params = new FrameLayout.LayoutParams(-2, -2, 17);
            int margin = this.getResources().getDimensionPixelSize(R.dimen.action_button_content_margin);
            params.setMargins(margin, margin, margin, margin);
        } else {
            params = contentParams;
        }
        params.gravity = 17;
        contentView.setClickable(false);
        this.addView(contentView, (ViewGroup.LayoutParams)params);
    }

    public void attach(ViewGroup.LayoutParams layoutParams) {
        if (this.systemOverlay) {
            try {
                this.getWindowManager().addView((View)this, layoutParams);
            }
            catch (SecurityException e) {
                throw new SecurityException("Your application must have SYSTEM_ALERT_WINDOW permission to create a system window.");
            }
        } else {
            ((ViewGroup)this.getActivityContentView()).addView((View)this, layoutParams);
        }
    }

    public void detach() {
        if (this.systemOverlay) {
            this.getWindowManager().removeView((View)this);
        } else {
            ((ViewGroup)this.getActivityContentView()).removeView((View)this);
        }
    }

    public View getActivityContentView() {
        try {
            return ((Activity)this.getContext()).getWindow().getDecorView().findViewById(0x1020002);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Please provide an Activity context for this FloatingActionButton.");
        }
    }

    public WindowManager getWindowManager() {
        return (WindowManager)this.getContext().getSystemService("window");
    }

    private void setBackgroundResource(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    public static class Builder {
        private Context context;
        private ViewGroup.LayoutParams layoutParams;
        private int theme;
        private Drawable backgroundDrawable;
        private int position;
        private View contentView;
        private FrameLayout.LayoutParams contentParams;
        private boolean systemOverlay;

        public Builder(Context context) {
            this.context = context;
            int size = context.getResources().getDimensionPixelSize(R.dimen.action_button_size);
            int margin = context.getResources().getDimensionPixelSize(R.dimen.action_button_margin);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(size, size, 85);
            layoutParams.setMargins(margin, margin, margin, margin);
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.setTheme(0);
            this.setPosition(4);
            this.setSystemOverlay(false);
        }

        public Builder setLayoutParams(ViewGroup.LayoutParams params) {
            this.layoutParams = params;
            return this;
        }

        public Builder setTheme(int theme) {
            this.theme = theme;
            return this;
        }

        public Builder setBackgroundDrawable(Drawable backgroundDrawable) {
            this.backgroundDrawable = backgroundDrawable;
            return this;
        }

        public Builder setBackgroundDrawable(int drawableId) {
            return this.setBackgroundDrawable(this.context.getResources().getDrawable(drawableId));
        }

        public Builder setPosition(int position) {
            this.position = position;
            return this;
        }

        public Builder setContentView(View contentView) {
            return this.setContentView(contentView, null);
        }

        public Builder setContentView(View contentView, FrameLayout.LayoutParams contentParams) {
            this.contentView = contentView;
            this.contentParams = contentParams;
            return this;
        }

        public Builder setSystemOverlay(boolean systemOverlay) {
            this.systemOverlay = systemOverlay;
            return this;
        }

        public FloatingActionButton build() {
            return new FloatingActionButton(this.context, this.layoutParams, this.theme, this.backgroundDrawable, this.position, this.contentView, this.contentParams, this.systemOverlay);
        }

        public static WindowManager.LayoutParams getDefaultSystemWindowParams(Context context) {
            int size = context.getResources().getDimensionPixelSize(R.dimen.action_button_size);
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(size, size, 2003, 40, -3);
            params.format = 1;
            params.gravity = 51;
            return params;
        }
    }
}

