/*
 * Decompiled with CFR 0.152.
 */
package com.customfabs.animation;

import android.animation.Animator;
import android.graphics.Point;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.customfabs.FloatingActionMenu;

public abstract class MenuAnimationHandler {
    protected FloatingActionMenu menu;

    public void setMenu(FloatingActionMenu menu) {
        this.menu = menu;
    }

    public void animateMenuOpening(Point center) {
        if (this.menu == null) {
            throw new NullPointerException("MenuAnimationHandler cannot animate without a valid FloatingActionMenu.");
        }
    }

    public void animateMenuClosing(Point center) {
        if (this.menu == null) {
            throw new NullPointerException("MenuAnimationHandler cannot animate without a valid FloatingActionMenu.");
        }
    }

    protected void restoreSubActionViewAfterAnimation(FloatingActionMenu.Item subActionItem, ActionType actionType) {
        ViewGroup.LayoutParams params = subActionItem.view.getLayoutParams();
        subActionItem.view.setTranslationX(0.0f);
        subActionItem.view.setTranslationY(0.0f);
        subActionItem.view.setRotation(0.0f);
        subActionItem.view.setScaleX(1.0f);
        subActionItem.view.setScaleY(1.0f);
        subActionItem.view.setAlpha(1.0f);
        if (actionType == ActionType.OPENING) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)params;
            if (this.menu.isSystemOverlay()) {
                WindowManager.LayoutParams overlayParams = (WindowManager.LayoutParams)this.menu.getOverlayContainer().getLayoutParams();
                lp.setMargins(subActionItem.x - overlayParams.x, subActionItem.y - overlayParams.y, 0, 0);
            } else {
                lp.setMargins(subActionItem.x, subActionItem.y, 0, 0);
            }
            subActionItem.view.setLayoutParams((ViewGroup.LayoutParams)lp);
        } else if (actionType == ActionType.CLOSING) {
            Point center = this.menu.getActionViewCenter();
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)params;
            if (this.menu.isSystemOverlay()) {
                WindowManager.LayoutParams overlayParams = (WindowManager.LayoutParams)this.menu.getOverlayContainer().getLayoutParams();
                lp.setMargins(center.x - overlayParams.x - subActionItem.width / 2, center.y - overlayParams.y - subActionItem.height / 2, 0, 0);
            } else {
                lp.setMargins(center.x - subActionItem.width / 2, center.y - subActionItem.height / 2, 0, 0);
            }
            subActionItem.view.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.menu.removeViewFromCurrentContainer(subActionItem.view);
            if (this.menu.isSystemOverlay() && this.menu.getOverlayContainer().getChildCount() == 0) {
                this.menu.detachOverlayContainer();
            }
        }
    }

    public abstract boolean isAnimating();

    protected abstract void setAnimating(boolean var1);

    public class LastAnimationListener
    implements Animator.AnimatorListener {
        public void onAnimationStart(Animator animation) {
            MenuAnimationHandler.this.setAnimating(true);
        }

        public void onAnimationEnd(Animator animation) {
            MenuAnimationHandler.this.setAnimating(false);
        }

        public void onAnimationCancel(Animator animation) {
            MenuAnimationHandler.this.setAnimating(false);
        }

        public void onAnimationRepeat(Animator animation) {
            MenuAnimationHandler.this.setAnimating(true);
        }
    }

    protected static enum ActionType {
        OPENING,
        CLOSING;

    }
}

