/*
 * Decompiled with CFR 0.152.
 */
package com.customfabs;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.customfabs.R;

public class FloatingActionBackPanel
extends FrameLayout {
    public static final int THEME_LIGHT = 0;
    public static final int THEME_DARK = 1;
    public static final int THEME_LIGHTER = 2;
    public static final int THEME_DARKER = 3;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FloatingActionBackPanel(Context context, ViewGroup.LayoutParams layoutParams, int theme, Drawable backgroundDrawable, View contentView, FrameLayout.LayoutParams contentParams) {
        super(context);
        this.setLayoutParams(layoutParams);
        if (backgroundDrawable == null) {
            if (theme == 0) {
                backgroundDrawable = context.getResources().getDrawable(R.drawable.button_sub_action_selector);
            } else if (theme == 1) {
                backgroundDrawable = context.getResources().getDrawable(R.drawable.button_sub_action_dark_selector);
            } else if (theme == 2) {
                backgroundDrawable = context.getResources().getDrawable(R.drawable.button_action_selector);
            } else {
                if (theme != 3) throw new RuntimeException("Unknown SubActionButton theme: " + theme);
                backgroundDrawable = context.getResources().getDrawable(R.drawable.button_action_dark_selector);
            }
        } else {
            backgroundDrawable = backgroundDrawable.mutate().getConstantState().newDrawable();
        }
        this.setBackgroundResource(backgroundDrawable);
        if (contentView == null) return;
        this.setContentView(contentView, contentParams);
    }

    private void setBackgroundResource(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    public void setContentView(View contentView, FrameLayout.LayoutParams params) {
        if (params == null) {
            params = new FrameLayout.LayoutParams(-2, -2, 17);
            int margin = this.getResources().getDimensionPixelSize(R.dimen.sub_action_button_content_margin);
            params.setMargins(margin, margin, margin, margin);
        }
        contentView.setClickable(false);
        this.addView(contentView, (ViewGroup.LayoutParams)params);
    }

    public static class Builder {
        private Context context;
        private ViewGroup.LayoutParams layoutParams;
        private int theme;
        private int position;
        private boolean systemOverlay;
        private Drawable backgroundDrawable;
        private View contentView;
        private FrameLayout.LayoutParams contentParams;

        public Builder(Context context) {
            this.context = context;
            int size = context.getResources().getDimensionPixelSize(R.dimen.action_button_panel_size);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(size, size, 85);
            this.setLayoutParams((ViewGroup.LayoutParams)params);
            this.setTheme(0);
        }

        public Builder setLayoutParams(ViewGroup.LayoutParams layoutParams) {
            this.layoutParams = layoutParams;
            return this;
        }

        public Builder setTheme(int theme) {
            this.theme = theme;
            return this;
        }

        public Builder setBackgroundDrawable(Drawable backgroundDrawable) {
            this.backgroundDrawable = backgroundDrawable;
            return this;
        }

        public Builder setContentView(View contentView) {
            return this.setContentView(contentView, null);
        }

        public Builder setContentView(View contentView, FrameLayout.LayoutParams contentParams) {
            this.contentView = contentView;
            this.contentParams = contentParams;
            return this;
        }

        public Builder setSystemOverlay(boolean systemOverlay) {
            this.systemOverlay = systemOverlay;
            return this;
        }

        public FloatingActionBackPanel build() {
            return new FloatingActionBackPanel(this.context, this.layoutParams, this.theme, this.backgroundDrawable, this.contentView, this.contentParams);
        }
    }
}

