/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.animation.impl;

import android.view.View;
import androidx.annotation.NonNull;
import com.zegome.utils.animation.IAnimation;
import com.zegome.utils.animation.IUpdate;
import com.zegome.utils.animation.IViewAnimation;
import com.zegome.utils.animation.impl.ZAnimation;
import com.zegome.utils.animation.impl.ZUpdateController;
import java.util.Collection;
import java.util.HashMap;

public class ZViewAnimation
implements IViewAnimation {
    private static final String TRANS_X = "trans_x";
    private static final String TRANS_Y = "trans_y";
    private static final String SCALE_X = "scale_x";
    private static final String SCALE_Y = "scale_y";
    private static final String ROTATION = "rotation";
    private static final String ALPHA = "alpha";
    private View mTarget = null;
    private ZUpdateController mParent = null;
    private boolean mIsRunning = false;
    private boolean mIsAutoRemove = false;
    private HashMap<String, IAnimation> mAnimations = new HashMap();
    private IViewAnimation.IAnimationListener mListener;

    private ZViewAnimation() {
    }

    @Override
    public IViewAnimation setTarget(View view) {
        this.mTarget = view;
        return this;
    }

    @Override
    public View getTarget() {
        return this.mTarget;
    }

    @Override
    public boolean isRunning() {
        return this.mIsRunning;
    }

    @Override
    public boolean isAutoRemove() {
        return this.mIsAutoRemove;
    }

    @Override
    public void setAutoRemove(boolean autoRemove) {
        this.mIsAutoRemove = autoRemove;
    }

    @Override
    public IViewAnimation setListener(IViewAnimation.IAnimationListener listener) {
        this.mListener = listener;
        return this;
    }

    @Override
    public ZUpdateController getParent() {
        return this.mParent;
    }

    @Override
    public void setParent(IUpdate.IUpdatable updatable) {
        if (updatable == null || !(updatable instanceof ZUpdateController)) {
            throw new IllegalArgumentException("parent must be ZUpdateController and not null");
        }
        this.mParent = (ZUpdateController)updatable;
    }

    @Override
    public IViewAnimation translationX(float from, float to, long duration) {
        IAnimation animation = ZAnimation.create().from(from).to(to).duration(duration);
        this.removeIfContain(TRANS_X);
        this.mAnimations.put(TRANS_X, animation);
        return this;
    }

    @Override
    public IViewAnimation translationY(float from, float to, long duration) {
        IAnimation animation = ZAnimation.create().from(from).to(to).duration(duration);
        this.removeIfContain(TRANS_Y);
        this.mAnimations.put(TRANS_Y, animation);
        return this;
    }

    @Override
    public IViewAnimation alpha(float from, float to, long duration) {
        IAnimation animation = ZAnimation.create().from(from).to(to).duration(duration);
        this.removeIfContain(ALPHA);
        this.mAnimations.put(ALPHA, animation);
        return this;
    }

    @Override
    public IViewAnimation rotation(float from, float to, long duration) {
        IAnimation animation = ZAnimation.create().from(from).to(to).duration(duration);
        this.removeIfContain(ROTATION);
        this.mAnimations.put(ROTATION, animation);
        return this;
    }

    @Override
    public IViewAnimation scale(float from, float to, long duration) {
        this.scaleX(from, to, duration);
        return this;
    }

    @Override
    public IViewAnimation scaleX(float from, float to, long duration) {
        this.scaleY(from, to, duration);
        return this;
    }

    @Override
    public IViewAnimation scaleY(float from, float to, long duration) {
        IAnimation animation = ZAnimation.create().from(from).to(to).duration(duration);
        this.removeIfContain(SCALE_Y);
        this.mAnimations.put(SCALE_Y, animation);
        return this;
    }

    @Override
    public void removeSelf() {
        this.mIsRunning = false;
    }

    @Override
    public void onUpdate(float delta) {
        Collection<IAnimation> animations = this.mAnimations.values();
        for (IAnimation ani : animations) {
            ani.onUpdate(delta);
        }
    }

    @Override
    public void onPost() {
        IAnimation animation;
        if (this.mAnimations.containsKey(TRANS_X)) {
            animation = this.mAnimations.get(TRANS_X);
            this.mTarget.setTranslationX(animation.getValue());
        }
        if (this.mAnimations.containsKey(TRANS_Y)) {
            animation = this.mAnimations.get(TRANS_Y);
            this.mTarget.setTranslationY(animation.getValue());
        }
        if (this.mAnimations.containsKey(SCALE_X)) {
            animation = this.mAnimations.get(SCALE_X);
            this.mTarget.setScaleX(animation.getValue());
        }
        if (this.mAnimations.containsKey(SCALE_Y)) {
            animation = this.mAnimations.get(SCALE_Y);
            this.mTarget.setScaleY(animation.getValue());
        }
        if (this.mAnimations.containsKey(ROTATION)) {
            animation = this.mAnimations.get(ROTATION);
            this.mTarget.setRotation(animation.getValue());
        }
        if (this.mAnimations.containsKey(ALPHA)) {
            animation = this.mAnimations.get(ALPHA);
            this.mTarget.setAlpha(animation.getValue());
        }
    }

    @Override
    public void start() {
        if (this.mTarget == null) {
            throw new IllegalArgumentException("target must be difference null");
        }
        this.mIsRunning = true;
        Collection<IAnimation> animations = this.mAnimations.values();
        for (IAnimation ani : animations) {
            ani.start();
        }
        this.mParent.addChild(this);
        if (this.mListener != null) {
            this.mListener.onStart(this);
        }
    }

    @Override
    public void stop() {
        this.mIsAutoRemove = true;
        this.mIsRunning = false;
        if (this.mListener != null) {
            this.mListener.onCompleted(this);
        }
    }

    public static ZViewAnimation with(ZUpdateController controller) {
        ZViewAnimation animation = new ZViewAnimation();
        animation.setParent(controller);
        return animation;
    }

    private void removeIfContain(@NonNull String key) {
        if (this.mAnimations.containsKey(key)) {
            this.mAnimations.remove(key);
        }
    }
}

