/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.widget.pagers;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import com.zegome.utils.widget.XScrollDetector;
import com.zegome.utils.widget.pagers.ZDurationScroller;
import java.lang.reflect.Field;

public class ZViewPager
extends ViewPager {
    private boolean isSwipe = false;
    private boolean isAnimation = true;
    protected ZDurationScroller mScroller = null;
    private GestureDetector mGestureDetector;
    private boolean mIsCheckGesture = true;

    public ZViewPager(Context context) {
        this(context, null);
    }

    public ZViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new XScrollDetector(2.0f));
        this.postInitViewPager();
    }

    public void setSwipe(boolean swipe) {
        this.isSwipe = swipe;
    }

    public void setAni(boolean animation) {
        this.isAnimation = animation;
    }

    public void setCurrentItem(int item) {
        super.setCurrentItem(item, this.isAnimation);
    }

    public void setScrollDurationFactor(double scrollFactor) {
        if (null == this.mScroller) {
            return;
        }
        this.mScroller.setScrollDurationFactor(scrollFactor);
    }

    public long getScrollDuration() {
        return null != this.mScroller ? this.mScroller.getDuration() : 0;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.isSwipe) {
            return super.onInterceptTouchEvent(event) && (!this.mIsCheckGesture || this.mGestureDetector.onTouchEvent(event));
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isSwipe) {
            super.onTouchEvent(event);
            boolean result = this.mGestureDetector.onTouchEvent(event);
            if (!result && event.getAction() == 1) {
                result = true;
            }
            return result;
        }
        return false;
    }

    private void postInitViewPager() {
        this.isSwipe = false;
        this.isAnimation = false;
        try {
            Field scroller = ViewPager.class.getDeclaredField("mScroller");
            scroller.setAccessible(true);
            Field interpolator = ViewPager.class.getDeclaredField("sInterpolator");
            interpolator.setAccessible(true);
            this.mScroller = new ZDurationScroller(this.getContext(), (Interpolator)interpolator.get(null));
            scroller.set((Object)this, (Object)this.mScroller);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

