/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.animation.impl;

import android.app.Activity;
import com.zegome.utils.animation.ILifeCycle;
import com.zegome.utils.animation.IUpdate;
import java.util.ArrayList;

public class ZUpdateController
implements IUpdate.IUpdatable,
ILifeCycle,
Runnable {
    private static final int MAX_FPS = 30;
    private static final int MAX_FRAME_SKIPS = 5;
    private static final int FRAME_PERIOD = 33;
    private static final float NANO_TIME = 1.0E9f;
    private Activity mActivity;
    Thread mUpdateThread = null;
    volatile boolean mIsRunning = false;
    private ArrayList<IUpdate.IUpdatable> mChildren;
    private boolean mIsStartable = false;

    private ZUpdateController(Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("activity must be not null");
        }
        this.mIsStartable = false;
        this.mActivity = activity;
        this.mChildren = new ArrayList();
    }

    @Override
    public boolean isRunning() {
        return this.mIsRunning;
    }

    @Override
    public boolean isAutoRemove() {
        return true;
    }

    @Override
    public void setAutoRemove(boolean autoRemove) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(float delta) {
        ArrayList<IUpdate.IUpdatable> arrayList = this.mChildren;
        synchronized (arrayList) {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                IUpdate.IUpdatable updatable = this.mChildren.get(i);
                if (updatable.isRunning() || !updatable.isAutoRemove()) continue;
                this.mChildren.remove(updatable);
            }
            for (IUpdate.IUpdatable updatable : this.mChildren) {
                updatable.onUpdate(delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPost() {
        ArrayList<IUpdate.IUpdatable> arrayList = this.mChildren;
        synchronized (arrayList) {
            for (IUpdate.IUpdatable updatable : this.mChildren) {
                updatable.onPost();
            }
        }
    }

    @Override
    public void onResume() {
        if (this.mIsStartable) {
            this.onStart();
        }
    }

    @Override
    public void onPause() {
        this.destroy();
    }

    @Override
    public boolean onBackSelected() {
        return false;
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void onDestroy() {
        this.stop();
    }

    @Override
    public void run() {
        long startTime = System.nanoTime();
        int sleepTime = 0;
        while (this.mIsRunning) {
            long timeDiff;
            float deltaTime = (float)(System.nanoTime() - startTime) / 1.0E9f;
            startTime = System.nanoTime();
            long beginTime = System.currentTimeMillis();
            int framesSkipped = 0;
            if (this.mChildren != null) {
                this.onUpdate(deltaTime);
                this.mActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ZUpdateController.this.onPost();
                    }
                });
            }
            if ((sleepTime = (int)(33L - (timeDiff = System.currentTimeMillis() - beginTime))) > 0) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            while (sleepTime < 0 && framesSkipped < 5) {
                if (this.mChildren != null) {
                    this.onUpdate(deltaTime);
                }
                sleepTime += 33;
                ++framesSkipped;
            }
        }
    }

    @Override
    public void stop() {
        this.mIsStartable = false;
        this.destroy();
    }

    @Override
    public void start() {
        this.mIsStartable = true;
        this.onStart();
    }

    public static final ZUpdateController with(Activity activity) {
        return new ZUpdateController(activity);
    }

    private void destroy() {
        if (!this.mIsRunning) {
            return;
        }
        this.mIsRunning = false;
        while (true) {
            try {
                this.mUpdateThread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void onStart() {
        if (this.mIsRunning) {
            return;
        }
        this.mIsRunning = true;
        this.mUpdateThread = new Thread(this);
        this.mUpdateThread.start();
    }

    public void addChild(IUpdate.IUpdatable updatable) {
        this.mChildren.add(updatable);
    }

    public boolean removeChild(IUpdate.IUpdatable updatable) {
        if (this.mChildren.contains(updatable)) {
            return this.mChildren.remove(updatable);
        }
        return false;
    }
}

