/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.font;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.TextView;
import java.util.HashMap;

public class FontHelper {
    private static HashMap<String, Typeface> sFontCache = null;

    private FontHelper() {
    }

    public static void setCustomFont(@NonNull TextView textview, @NonNull String font, @NonNull Context context) {
        if (TextUtils.isEmpty((CharSequence)font)) {
            return;
        }
        Typeface tf = FontHelper.get(font, context);
        if (tf != null) {
            textview.setTypeface(tf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<String, Typeface> getFontCache() {
        if (sFontCache != null) return sFontCache;
        Class<FontHelper> clazz = FontHelper.class;
        synchronized (FontHelper.class) {
            if (sFontCache != null) return sFontCache;
            sFontCache = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFontCache;
        }
    }

    public static synchronized Typeface get(@NonNull String fontname, @NonNull Context context) {
        Typeface typeface = FontHelper.getFontCache().get(fontname);
        if (typeface == null) {
            try {
                typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontname);
            }
            catch (Exception e) {
                return null;
            }
            FontHelper.getFontCache().put(fontname, typeface);
        }
        return typeface;
    }
}

