/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.widget.pagers;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.MotionEventCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.zegome.utils.widget.pagers.ZViewPager;
import java.lang.ref.WeakReference;

public class ZAutoViewPager
extends ZViewPager {
    public static final int SCROLL_WHAT = 0;
    public static final int DEFAULT_INTERVAL = 3000;
    private long mInterval = 3000L;
    private boolean mIsStopWhenTouch = true;
    private Handler mHandler;
    private boolean mIsAutoScroll = false;
    private boolean mIsStopByTouch = false;

    public ZAutoViewPager(Context paramContext) {
        super(paramContext);
        this.init();
    }

    public ZAutoViewPager(Context paramContext, AttributeSet paramAttributeSet) {
        super(paramContext, paramAttributeSet);
        this.init();
    }

    public long getInterval() {
        return this.mInterval;
    }

    public void setInterval(long interval) {
        this.mInterval = interval;
    }

    public boolean isStopWhenTouch() {
        return this.mIsStopWhenTouch;
    }

    public void setStopWhenTouch(boolean stopScrollWhenTouch) {
        this.mIsStopWhenTouch = stopScrollWhenTouch;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (this.mIsStopWhenTouch) {
            if (action == 0 && this.mIsAutoScroll) {
                this.mIsStopByTouch = true;
                this.mScroller.useDefault = true;
                this.stopAutoScroll();
            } else if ((ev.getAction() == 1 || ev.getAction() == 3) && this.mIsStopByTouch) {
                this.mIsStopByTouch = false;
                this.mScroller.useDefault = false;
                this.startAutoScroll();
            }
        }
        this.getParent().requestDisallowInterceptTouchEvent(false);
        return super.dispatchTouchEvent(ev);
    }

    private void init() {
        this.mHandler = new MyHandler(this);
    }

    public void startAutoScroll() {
        this.mIsAutoScroll = true;
        this.sendScrollMessage(this.mInterval);
    }

    public void startAutoScroll(int delayTimeInMills) {
        this.mIsAutoScroll = true;
        this.sendScrollMessage(delayTimeInMills);
    }

    public void stopAutoScroll() {
        this.mIsAutoScroll = false;
        this.mHandler.removeMessages(0);
    }

    private void sendScrollMessage(long delayTimeInMills) {
        this.mHandler.removeMessages(0);
        this.mHandler.sendEmptyMessageDelayed(0, delayTimeInMills);
    }

    private static class MyHandler
    extends Handler {
        private final WeakReference<ZAutoViewPager> autoScrollViewPager;

        public MyHandler(ZAutoViewPager zViewPager) {
            this.autoScrollViewPager = new WeakReference<ZAutoViewPager>(zViewPager);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    int count;
                    int next;
                    ZAutoViewPager pager = (ZAutoViewPager)((Object)this.autoScrollViewPager.get());
                    if (pager == null) break;
                    int curr = pager.getCurrentItem();
                    int n = next = curr >= (count = pager.getAdapter().getCount()) - 1 ? 0 : curr + 1;
                    if (next == 0) {
                        pager.setCurrentItem(next, false);
                    } else {
                        pager.setCurrentItem(next);
                    }
                    pager.sendScrollMessage(pager.mInterval + pager.getScrollDuration());
                }
            }
        }
    }
}

