/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.StatFs;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.format.DateFormat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;

public final class Utils {
    public static final String STRING_EMPTY = "";
    public static final int NONE = -1;
    public static final String COPY_RIGHT_C_LETTER = "\u00a9";

    public static boolean isEmulator() {
        String buildManufacturer = Build.MANUFACTURER;
        String buildModel = Build.MODEL;
        return Utils.isGenymotionEmulator(buildManufacturer) || Utils.containsEmulatorHints(buildModel);
    }

    public static boolean isGenymotionEmulator(String buildManufacturer) {
        return buildManufacturer != null && (buildManufacturer.contains("Genymotion") || buildManufacturer.equals("unknown"));
    }

    public static boolean containsEmulatorHints(String buildModel) {
        return buildModel.startsWith("sdk") || "google_sdk".equals(buildModel) || buildModel.contains("Emulator") || buildModel.contains("Android SDK");
    }

    public static String getStringFileFromAssets(@NonNull Context context, @NonNull String fileDir) {
        String json = null;
        try {
            InputStream is = context.getAssets().open(fileDir);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            json = new String(buffer, "UTF-8");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return json;
    }

    public static String getDateStrFromUTC(@NonNull Context context, String UTCStr) {
        return Utils.getDateStrFromUTC(UTCStr, DateFormat.getDateFormat((Context)context.getApplicationContext()));
    }

    public static String getDateStrFromUTC(String UTCStr, String targetPattern) {
        return Utils.getDateStrFromUTC(UTCStr, new SimpleDateFormat(targetPattern));
    }

    public static String getDateStrFromUTC(String UTCStr, java.text.DateFormat targetDateFormat) {
        try {
            SimpleDateFormat mISO8601Local;
            if (Utils.isStringEmptyorNull(UTCStr)) {
                return UTCStr;
            }
            if (UTCStr.contains("Z")) {
                String format = "yyyy-MM-dd'T'HH:mm:ss'Z'";
                mISO8601Local = new SimpleDateFormat(format);
                mISO8601Local.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                String format = "yyyy-MM-dd'T'HH:mm:ss";
                mISO8601Local = new SimpleDateFormat(format);
            }
            Date date = mISO8601Local.parse(UTCStr);
            java.text.DateFormat dateFormat = targetDateFormat;
            String ret = dateFormat.format(date);
            return ret;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return UTCStr;
        }
    }

    public static Date getDateFromUTC(@NonNull Context context, String UTCStr) {
        try {
            SimpleDateFormat mISO8601Local;
            if (Utils.isStringEmptyorNull(UTCStr)) {
                return null;
            }
            if (UTCStr.contains("Z")) {
                String format = "yyyy-MM-dd'T'HH:mm:ss'Z'";
                mISO8601Local = new SimpleDateFormat(format);
                mISO8601Local.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                String format = "yyyy-MM-dd'T'HH:mm:ss";
                mISO8601Local = new SimpleDateFormat(format);
            }
            Date date = mISO8601Local.parse(UTCStr);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Dialog getDialog(Context context) {
        return Utils.getDialog(context, -1);
    }

    public static Dialog getDialog(Context context, int layout) {
        try {
            Dialog dialog = new Dialog(context);
            dialog.requestWindowFeature(1);
            dialog.getWindow().setFlags(1024, 1024);
            if (-1 != layout) {
                dialog.setContentView(layout);
            }
            return dialog;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Dialog getDialog(Context context, int layout, int theme) {
        try {
            Dialog dialog = new Dialog(context, theme);
            dialog.requestWindowFeature(1);
            dialog.getWindow().setFlags(1024, 1024);
            if (-1 != layout) {
                dialog.setContentView(layout);
            }
            return dialog;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final boolean isPackageInstalled(@NonNull Context context, String packagename) {
        try {
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo(packagename, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static final Intent getLaunchIntentForPackage(@NonNull Context context, String packageName) {
        try {
            Intent intentToResolve = new Intent("android.intent.action.MAIN");
            intentToResolve.addCategory("android.intent.category.INFO");
            intentToResolve.setPackage(packageName);
            PackageManager pm = context.getPackageManager();
            List ris = pm.queryIntentActivities(intentToResolve, 0);
            if (ris == null || ris.size() <= 0) {
                intentToResolve.removeCategory("android.intent.category.INFO");
                intentToResolve.addCategory("android.intent.category.LAUNCHER");
                intentToResolve.setPackage(packageName);
                ris = pm.queryIntentActivities(intentToResolve, 0);
            }
            if (ris == null || ris.size() <= 0) {
                return null;
            }
            Intent intent = new Intent(intentToResolve);
            intent.setFlags(0x10000000);
            intent.setClassName(((ResolveInfo)ris.get((int)0)).activityInfo.packageName, ((ResolveInfo)ris.get((int)0)).activityInfo.name);
            return intent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static final String getCopyRight(String company) {
        int currYear = Utils.getCurrentYear();
        String ret = "\u00a9 " + currYear + " - " + company;
        return ret;
    }

    public static int getListViewHeightBasedOnChildren(@NonNull ListView listView) {
        ListAdapter listAdapter = listView.getAdapter();
        try {
            if (listAdapter != null) {
                int totalHeight = 0;
                int size = listAdapter.getCount();
                for (int i = 0; i < size; ++i) {
                    View listItem = listAdapter.getView(i, null, (ViewGroup)listView);
                    if (listItem == null) continue;
                    listItem.measure(0, 0);
                    totalHeight += listItem.getMeasuredHeight();
                }
                return totalHeight += listView.getDividerHeight() * (listAdapter.getCount() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static final boolean isNetworkActive(@NonNull Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static final void isNetworkActive(final @NonNull Activity ac, final INetworkCheckCallback callback) {
        if (callback == null) {
            return;
        }
        ac.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ConnectivityManager connectivityManager = (ConnectivityManager)ac.getSystemService("connectivity");
                NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
                callback.onCompleted(activeNetworkInfo != null && activeNetworkInfo.isConnected());
            }
        });
    }

    public static final String checkNetworkType(Context context) {
        boolean mobileConnected;
        boolean wifiConnected;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo wifiInfo = connectivityManager.getNetworkInfo(1);
        boolean bl = wifiConnected = wifiInfo.getState() == NetworkInfo.State.CONNECTED;
        if (wifiConnected) {
            return "wifi";
        }
        NetworkInfo mobileInfo = connectivityManager.getNetworkInfo(0);
        boolean bl2 = mobileConnected = mobileInfo.getState() == NetworkInfo.State.CONNECTED;
        if (mobileConnected) {
            return "3G/4G";
        }
        return "disconnected";
    }

    private static final long getRamFree(Context context) {
        ActivityManager.MemoryInfo memoryInfo = Utils.getAvailableMemory(context);
        return memoryInfo.availMem / 0x100000L;
    }

    @RequiresApi(api=16)
    private static final long getRamTotal(Context context) {
        ActivityManager.MemoryInfo memoryInfo = Utils.getAvailableMemory(context);
        return memoryInfo.totalMem / 0x100000L;
    }

    private static ActivityManager.MemoryInfo getAvailableMemory(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo;
    }

    public static final long getMemmorySD() {
        StatFs stat = new StatFs(Environment.getExternalStorageDirectory().getPath());
        long bytesAvailable = (long)stat.getBlockSize() * (long)stat.getBlockCount();
        long megAvailable = bytesAvailable / 0x100000L;
        return megAvailable;
    }

    public static final long getDiskInternalTotal(Context context) {
        StatFs stat = new StatFs(context.getFilesDir().getPath());
        long bytesAvailable = (long)stat.getBlockSize() * (long)stat.getBlockCount();
        long megAvailable = bytesAvailable / 0x100000L;
        return megAvailable;
    }

    public static final long getDiskInternalFree(Context context) {
        StatFs stat = new StatFs(context.getFilesDir().getPath());
        long bytesAvailable = (long)stat.getBlockSize() * (long)stat.getAvailableBlocks();
        long megAvailable = bytesAvailable / 0x100000L;
        return megAvailable;
    }

    @TargetApi(value=23)
    public static final boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static boolean isNull(Object object) {
        return null == object;
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static boolean isStringEmptyorNull(String str) {
        return str == null || str.equals(STRING_EMPTY);
    }

    public static String ensureStringNotNull(String str) {
        return str == null ? STRING_EMPTY : str;
    }

    public static void showToast(final @NonNull Context context, final @NonNull String message) {
        if (Utils.isMainThread()) {
            Toast.makeText((Context)context, (CharSequence)(STRING_EMPTY + message), (int)0).show();
        } else if (context instanceof Activity) {
            ((Activity)context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)context, (CharSequence)(Utils.STRING_EMPTY + message), (int)0).show();
                }
            });
        }
    }

    public static boolean gotoWebsite(Context context, String url) {
        try {
            url = url.trim();
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                url = "http://" + url;
            }
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            context.startActivity(browserIntent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final void callShareAction(@NonNull Activity activity, @NonNull String appName, @NonNull String shareMessage, @NonNull String chooserStr) {
        if (activity == null) {
            return;
        }
        try {
            Intent shareIntent = new Intent("android.intent.action.SEND");
            shareIntent.setType("text/plain");
            shareIntent.putExtra("android.intent.extra.SUBJECT", appName);
            shareIntent.putExtra("android.intent.extra.TEXT", shareMessage);
            activity.startActivity(Intent.createChooser((Intent)shareIntent, (CharSequence)chooserStr));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void callShareActionForResult(@NonNull Activity activity, @NonNull String appName, @NonNull String shareMessage, @NonNull String chooserStr, int requestCode) {
        if (activity == null) {
            return;
        }
        try {
            Intent shareIntent = new Intent("android.intent.action.SEND");
            shareIntent.setType("text/plain");
            shareIntent.putExtra("android.intent.extra.SUBJECT", appName);
            shareIntent.putExtra("android.intent.extra.TEXT", shareMessage);
            activity.startActivityForResult(Intent.createChooser((Intent)shareIntent, (CharSequence)chooserStr), requestCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String[] split(String source, char delimiter) {
        String tmp;
        if (source == null) {
            return null;
        }
        if ((source = source.trim()).equals(STRING_EMPTY)) {
            return new String[]{STRING_EMPTY};
        }
        if (source.indexOf(delimiter, 0) < 0) {
            return new String[]{source};
        }
        Vector<String> v = new Vector<String>();
        int startIndex = 0;
        int idx = source.indexOf(delimiter, startIndex);
        if (idx < 0) {
            return null;
        }
        while (idx >= 0) {
            tmp = source.substring(startIndex, idx).trim();
            v.addElement(tmp);
            startIndex = idx + 1;
            idx = source.indexOf(delimiter, startIndex);
            tmp = null;
        }
        if (v.size() == 0) {
            return null;
        }
        tmp = source.substring(source.lastIndexOf(delimiter) + 1, source.length());
        v.addElement(tmp);
        tmp = null;
        String[] r = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            r[i] = ((String)v.elementAt(i)).toString();
        }
        return r;
    }

    public static void startInstalledAppDetailsActivity(@NonNull Context context) {
        if (context == null) {
            return;
        }
        try {
            Intent intent = new Intent();
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.setData(Uri.parse((String)("package:" + context.getPackageName())));
            intent.addFlags(0x10000000);
            intent.addFlags(0x40000000);
            intent.addFlags(0x800000);
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String stringNoEnter(String str) {
        return str.replaceAll("[\r\n]", STRING_EMPTY);
    }

    public static int dpAsPixels(@NonNull Context context, float sizeInDp) {
        float scale = context.getResources().getDisplayMetrics().density;
        return Utils.dpAsPixels(sizeInDp, scale);
    }

    public static int dpAsPixels(float sizeInDp, float density) {
        int dpAsPixels = (int)(sizeInDp * density + 0.5f);
        return dpAsPixels;
    }

    public static final void openAppPackage(Activity activity, String appPackage) {
        Intent intent = Utils.getLaunchIntentForPackage((Context)activity, appPackage);
        if (intent != null) {
            activity.startActivity(intent);
            return;
        }
        Utils.gotoPlayStore(activity, appPackage);
    }

    public static final void gotoPlayStore(@NonNull Activity activity, String appPackage) {
        if (Utils.isStringEmptyorNull(appPackage)) {
            return;
        }
        try {
            String link = "market://details?id=" + appPackage;
            activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)link)));
        }
        catch (ActivityNotFoundException anfe) {
            try {
                activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("http://play.google.com/store/apps/details?id=" + appPackage))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void callSendViaOtherApp(@NonNull Context context, String content, String subject) {
        try {
            Intent sendIntent = new Intent();
            sendIntent.setAction("android.intent.action.SEND");
            sendIntent.putExtra("android.intent.extra.TEXT", content);
            if (!Utils.isStringEmptyorNull(subject)) {
                sendIntent.putExtra("android.intent.extra.SUBJECT", subject);
            }
            sendIntent.setType("text/plain");
            context.startActivity(sendIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void callSendMail(@NonNull Context context, String to, String appName, String subject, String message) {
        if (context == null) {
            return;
        }
        try {
            Intent email = new Intent("android.intent.action.SEND");
            email.putExtra("android.intent.extra.EMAIL", new String[]{Utils.ensureStringNotNull(to)});
            email.putExtra("android.intent.extra.SUBJECT", Utils.ensureStringNotNull(subject));
            email.putExtra("android.intent.extra.TEXT", Utils.ensureStringNotNull(message));
            email.setType("message/rfc822");
            context.startActivity(Intent.createChooser((Intent)email, (CharSequence)"Choose an Email client :"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface INetworkCheckCallback {
        public void onCompleted(boolean var1);
    }
}

