package com.zegome.utils.widget;

import android.content.Context;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;

/**
 * Created by QuanLT on 1/6/16.
 */

public class ZNestedScrollView extends NestedScrollView{
    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================
    private OnScrollListener mScrollListener;
    private GestureDetector mGestureDetector;

    private boolean mIsCheckGesture = true;

    // ===========================================================
    // Constructors
    // ===========================================================
    public ZNestedScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);

        mGestureDetector = new GestureDetector(context, new YDeepScrollDetector());
        setFadingEdgeLength(0);
    }

    // ===========================================================
    // Getter & Setter
    // ===========================================================

    public void setCheckGesture(boolean checkGesture) {
        mIsCheckGesture = checkGesture;
    }

    public void setScrollListener(OnScrollListener scrollListener) {
        mScrollListener = scrollListener;
    }

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public boolean startNestedScroll(int axes) {
        if (mScrollListener != null) {
            mScrollListener.onStart();
        }
        return super.startNestedScroll(axes);
    }

    @Override
    public void stopNestedScroll() {
        super.stopNestedScroll();
        if (mScrollListener != null) {
            mScrollListener.onStop();
        }
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return super.onInterceptTouchEvent(ev)
                && (mIsCheckGesture ? mGestureDetector.onTouchEvent(ev) : true);
    }


    // ===========================================================
    // Methods
    // ===========================================================

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================
    private class YDeepScrollDetector extends GestureDetector.SimpleOnGestureListener {
        // Return false if we're scrolling in the x direction
        @Override
        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return (Math.abs(distanceY) > Math.abs(distanceX) && (Math.abs(distanceY) >= Math.abs(distanceX) * 5 || distanceX == 0));
        }
    }

    public interface OnScrollListener {
        void onStop();
        void onStart();
        boolean isScrolling();
    }
}
