/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.xml;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import com.zegome.utils.xml.XMLNode;
import com.zegome.utils.xml.XMLParserHanler;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLReaderUtil {
    private static String readTextFile(Context context, String fileName) {
        AssetManager assetManager = context.getAssets();
        InputStream inputStream = null;
        try {
            inputStream = assetManager.open(fileName);
        }
        catch (IOException e) {
            Log.e((String)"tag", (String)e.getMessage());
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toString();
    }

    public static ArrayList<XMLNode> read(Context context, String fileName, String parent, String ... keys) {
        ArrayList<String> keyForRead = new ArrayList<String>();
        for (int i = 0; i < keys.length; ++i) {
            keyForRead.add(keys[i]);
        }
        return XMLReaderUtil.read(context, fileName, keyForRead, parent);
    }

    public static ArrayList<XMLNode> read(Context context, String fileName, final ArrayList<String> keys, String parent) {
        try {
            String output = XMLReaderUtil.readTextFile(context, fileName);
            BufferedReader br = new BufferedReader(new StringReader(output));
            InputSource is = new InputSource(br);
            XMLParserHanler handler = new XMLParserHanler(parent, new XMLParserHanler.XMLNodeKeyFactory(){

                @Override
                public ArrayList<String> getKeys() {
                    return keys;
                }
            });
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser sp = factory.newSAXParser();
            XMLReader reader = sp.getXMLReader();
            reader.setContentHandler(handler);
            reader.parse(is);
            return handler.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

