/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.widget.TextView;
import com.zegome.utils.R;
import com.zegome.utils.font.FontHelper;

public class ZButton
extends AppCompatButton {
    private boolean mIsStroke = false;
    private int mStrokeWidth = 0;
    private int mStrokeColor;
    private boolean mCustomFont = false;
    private String mFontName = null;

    public ZButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public ZButton(Context context) {
        this(context, null);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mIsStroke) {
            ColorStateList states = this.getTextColors();
            this.getPaint().setStyle(Paint.Style.STROKE);
            this.getPaint().setStrokeWidth((float)this.mStrokeWidth);
            this.setTextColor(this.mStrokeColor);
            super.onDraw(canvas);
            this.getPaint().setStyle(Paint.Style.FILL);
            this.setTextColor(states);
        }
        super.onDraw(canvas);
    }

    private void initView(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ZButton);
        this.mIsStroke = a.getBoolean(R.styleable.ZButton_useStroke, false);
        this.mStrokeWidth = a.getDimensionPixelSize(R.styleable.ZButton_strokeWidth, 0);
        this.mStrokeColor = a.getColor(R.styleable.ZButton_strokeColor, -1);
        this.mCustomFont = a.getBoolean(R.styleable.ZButton_useFont, false);
        this.mFontName = a.getString(R.styleable.ZButton_fontName);
        if (this.mCustomFont && this.mFontName != null && !"".equals(this.mFontName)) {
            FontHelper.setCustomFont((TextView)this, this.mFontName, context);
        }
        a.recycle();
    }
}

